/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.server;

import java.lang.reflect.Method;
import jeus.util.properties.JeusRMIProperties;

public final class MethodInfo {
    public static boolean isStringSimple = JeusRMIProperties.ENALBE_STRING_SIMPLE;
    public static final byte Return_Void = 0;
    public static final byte Return_Int = 1;
    public static final byte Return_Boolean = 2;
    public static final byte Return_Byte = 3;
    public static final byte Return_Char = 4;
    public static final byte Return_Short = 5;
    public static final byte Return_Long = 6;
    public static final byte Return_Float = 7;
    public static final byte Return_Double = 8;
    public static final byte Return_IntArray = 9;
    public static final byte Return_BooleanArray = 10;
    public static final byte Return_ByteArray = 11;
    public static final byte Return_CharArray = 12;
    public static final byte Return_ShortArray = 13;
    public static final byte Return_LongArray = 14;
    public static final byte Return_FloatArray = 15;
    public static final byte Return_DoubleArray = 16;
    public static final byte Return_String = 17;
    public static final byte Return_Object = 18;
    private Method method;
    private byte return_type_number;
    private boolean isSimpleParam;

    public MethodInfo(Method m) {
        this.method = m;
        this.return_type_number = MethodInfo.getReturnTypeNumber(this.method);
        this.isSimpleParam = MethodInfo.isSimpleParams(this.method);
    }

    public static byte getReturnTypeNumber(Method method) {
        Class<?> rtype = method.getReturnType();
        if (rtype == Void.TYPE) {
            return 0;
        }
        if (rtype.isPrimitive()) {
            if (rtype == Integer.TYPE) {
                return 1;
            }
            if (rtype == Boolean.TYPE) {
                return 2;
            }
            if (rtype == Byte.TYPE) {
                return 3;
            }
            if (rtype == Character.TYPE) {
                return 4;
            }
            if (rtype == Short.TYPE) {
                return 5;
            }
            if (rtype == Long.TYPE) {
                return 6;
            }
            if (rtype == Float.TYPE) {
                return 7;
            }
            if (rtype == Double.TYPE) {
                return 8;
            }
        }
        if (rtype.isArray()) {
            Class<?> componentCl = rtype.getComponentType();
            if (componentCl.isPrimitive()) {
                if (componentCl == Integer.TYPE) {
                    return 9;
                }
                if (componentCl == Boolean.TYPE) {
                    return 10;
                }
                if (componentCl == Byte.TYPE) {
                    return 11;
                }
                if (componentCl == Character.TYPE) {
                    return 12;
                }
                if (componentCl == Short.TYPE) {
                    return 13;
                }
                if (componentCl == Long.TYPE) {
                    return 14;
                }
                if (componentCl == Float.TYPE) {
                    return 15;
                }
                if (componentCl == Double.TYPE) {
                    return 16;
                }
            }
        } else if (rtype == String.class) {
            return 17;
        }
        return 18;
    }

    private static boolean isSimpleType(Class type) {
        Class<?> componentCl;
        if (type.isPrimitive()) {
            return true;
        }
        return type.isArray() ? (componentCl = type.getComponentType()).isPrimitive() : isStringSimple && type == String.class;
    }

    public static boolean isSimpleParams(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params == null || params.length == 0) {
            return true;
        }
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            if (MethodInfo.isSimpleType(param)) continue;
            return false;
        }
        return true;
    }

    public Method getMethod() {
        return this.method;
    }

    public byte getReturn_type_number() {
        return this.return_type_number;
    }

    public boolean isVoidReturn() {
        return this.return_type_number == 0;
    }

    public static boolean isVoidReturn(byte _returnTypeNumber) {
        return _returnTypeNumber == 0;
    }

    public boolean isSimpleParam() {
        return this.isSimpleParam;
    }
}

