/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import jeus.rmi.impl.transport.Channel;
import jeus.rmi.impl.transport.EndpointCreator;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.impl.transport.support.EndpointSupport;

public class ClientEndpoint
extends EndpointSupport {
    protected Channel channel;

    public ClientEndpoint(String host, int port) {
        super(host, port);
    }

    public ClientEndpoint(String host, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        super(host, port, csf, ssf);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public static ClientEndpoint read(ObjectInput in) throws IOException, ClassNotFoundException {
        int port;
        String host;
        RMIClientSocketFactory csf = null;
        byte format = in.readByte();
        switch (format) {
            case 0: {
                host = in.readUTF();
                port = in.readInt();
                break;
            }
            case 1: {
                host = in.readUTF();
                port = in.readInt();
                csf = (RMIClientSocketFactory)in.readObject();
                break;
            }
            default: {
                throw new IOException("invalid endpoint format");
            }
        }
        return EndpointCreator.createClientEndpoint(host, port, csf);
    }

    public static ClientEndpoint readHostPortFormat(DataInput in) throws IOException {
        String host = in.readUTF();
        int port = in.readInt();
        return EndpointCreator.createClientEndpoint(host, port);
    }

    public void exportObject(Target target) throws RemoteException {
    }
}

