/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import jeus.rmi.impl.transport.ClientEndpoint;
import jeus.rmi.impl.transport.Endpoint;
import jeus.rmi.impl.transport.net.JeusClientEndpoint;
import jeus.rmi.impl.transport.net.JeusServerEndpoint;
import jeus.rmi.impl.transport.tcp.TCPClientEndpoint;
import jeus.rmi.impl.transport.tcp.TCPServerEndpoint;
import jeus.util.properties.JeusRMIProperties;

public class EndpointCreator {
    public static final boolean useNetworkEndpoint = JeusRMIProperties.USE_JEUS_NETWORK;

    public static Endpoint createEndpoint(String host, int port) {
        if (useNetworkEndpoint) {
            return new JeusServerEndpoint(host, port);
        }
        return new TCPServerEndpoint(host, port);
    }

    public static Endpoint createEndpoint(String host, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        if (useNetworkEndpoint) {
            return new JeusServerEndpoint(host, port, csf, ssf);
        }
        return new TCPServerEndpoint(host, port, csf, ssf);
    }

    public static Endpoint getLocalEndpoint(int port) {
        if (useNetworkEndpoint) {
            return JeusServerEndpoint.getLocalEndpoint(port);
        }
        return TCPServerEndpoint.getLocalEndpoint(port);
    }

    public static Endpoint getLocalEndpoint(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        if (useNetworkEndpoint) {
            return JeusServerEndpoint.getLocalEndpoint(port, csf, ssf);
        }
        return TCPServerEndpoint.getLocalEndpoint(port, csf, ssf);
    }

    public static Endpoint read(ObjectInput in) throws IOException, ClassNotFoundException {
        if (useNetworkEndpoint) {
            return JeusClientEndpoint.read(in);
        }
        return TCPClientEndpoint.read(in);
    }

    public static Endpoint readHostPortFormat(ObjectInput in) throws IOException {
        if (useNetworkEndpoint) {
            return JeusClientEndpoint.readHostPortFormat(in);
        }
        return TCPClientEndpoint.readHostPortFormat(in);
    }

    public static ClientEndpoint createClientEndpoint(String host, int port, RMIClientSocketFactory csf) {
        if (useNetworkEndpoint) {
            return JeusClientEndpoint.getLocalEndpoint(host, port, csf);
        }
        return TCPClientEndpoint.getLocalEndpoint(host, port, csf);
    }

    public static ClientEndpoint createClientEndpoint(String host, int port) {
        if (useNetworkEndpoint) {
            return JeusClientEndpoint.getLocalEndpoint(host, port, null);
        }
        return TCPClientEndpoint.getLocalEndpoint(host, port, null);
    }
}

