/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import jeus.rmi.impl.transport.Channel;
import jeus.rmi.impl.transport.Endpoint;
import jeus.rmi.impl.transport.EndpointCreator;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.spec.server.ObjID;

public class LiveRef
implements Cloneable {
    private final Endpoint ep;
    private final ObjID id;
    private transient Channel ch;
    private final boolean isLocal;

    public LiveRef(ObjID objID, Endpoint endpoint, boolean isLocal) {
        this.ep = endpoint;
        this.id = objID;
        this.isLocal = isLocal;
    }

    public LiveRef(int port) {
        this(new ObjID(), port);
    }

    public LiveRef(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        this(new ObjID(), port, csf, ssf);
    }

    public LiveRef(ObjID objID, int port) {
        this(objID, EndpointCreator.getLocalEndpoint(port), true);
    }

    public LiveRef(ObjID objID, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        this(objID, EndpointCreator.getLocalEndpoint(port, csf, ssf), true);
    }

    public Object clone() {
        try {
            LiveRef newRef = (LiveRef)super.clone();
            return newRef;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public int getPort() {
        return this.ep.getPort();
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.ep.getClientSocketFactory();
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ep.getServerSocketFactory();
    }

    public void exportObject(Target target) throws RemoteException {
        this.ep.exportObject(target);
    }

    public Channel getChannel() throws RemoteException {
        if (this.ch == null) {
            this.ch = this.ep.getChannel();
        }
        return this.ch;
    }

    public ObjID getObjID() {
        return this.id;
    }

    Endpoint getEndpoint() {
        return this.ep;
    }

    public String toString() {
        String type = this.isLocal ? "local" : "remote";
        return "[endpoint:" + this.ep + "(" + type + ")," + "objID:" + this.id + "]";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LiveRef) {
            LiveRef ref = (LiveRef)obj;
            return this.ep.equals(ref.ep) && this.id.equals(ref.id) && this.isLocal == ref.isLocal;
        }
        return false;
    }

    public boolean remoteEquals(Object obj) {
        if (obj != null && obj instanceof LiveRef) {
            LiveRef ref = (LiveRef)obj;
            Endpoint thisEp = this.ep;
            Endpoint refEp = ref.ep;
            RMIClientSocketFactory thisClientFactory = thisEp.getClientSocketFactory();
            RMIClientSocketFactory refClientFactory = refEp.getClientSocketFactory();
            if (thisEp.getPort() != refEp.getPort() || !thisEp.getHost().equals(refEp.getHost())) {
                return false;
            }
            if (thisClientFactory == null ^ refClientFactory == null) {
                return false;
            }
            if (!(thisClientFactory == null || thisClientFactory.getClass() == refClientFactory.getClass() && thisClientFactory.equals(refClientFactory))) {
                return false;
            }
            return this.id.equals(ref.id);
        }
        return false;
    }

    public void write(ObjectOutput out, boolean useNewFormat) throws IOException {
        if (useNewFormat) {
            this.ep.write(out);
        } else {
            this.ep.writeHostPortFormat(out);
        }
        this.id.write(out);
    }

    public static LiveRef read(ObjectInput in, boolean useNewFormat) throws IOException, ClassNotFoundException {
        Endpoint ep = useNewFormat ? EndpointCreator.read(in) : EndpointCreator.readHostPortFormat(in);
        ObjID id = ObjID.read(in);
        LiveRef ref = new LiveRef(id, ep, false);
        return ref;
    }
}

