/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.HashMap;
import java.util.Map;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.spec.server.ObjID;

public final class ObjectTable {
    private static final Object tableLock = new Object();
    private static final Map objTable = new HashMap();
    private static final Map implTable = new HashMap();

    private ObjectTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Target getTarget(ObjID id) {
        Object object = tableLock;
        synchronized (object) {
            return (Target)objTable.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Target getTarget(Remote impl) {
        Object object = tableLock;
        synchronized (object) {
            return (Target)implTable.get(impl);
        }
    }

    public static Remote getStub(Remote impl) throws NoSuchObjectException {
        Target target = ObjectTable.getTarget(impl);
        if (target == null) {
            throw new NoSuchObjectException("object not exported");
        }
        return target.getStub();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        Object object = tableLock;
        synchronized (object) {
            Target target = ObjectTable.getTarget(obj);
            if (target == null) {
                throw new NoSuchObjectException("object not exported");
            }
            if (target.unexport(force)) {
                ObjectTable.removeTarget(target);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putTarget(Target target) throws ExportException {
        ObjID id = target.getObjID();
        Remote impl = target.getImpl();
        if (impl == null) {
            throw new ExportException("internal error: attempt to export collected object");
        }
        Object object = tableLock;
        synchronized (object) {
            if (objTable.containsKey(id)) {
                throw new ExportException("internal error: ObjID already in use");
            }
            if (implTable.containsKey(impl)) {
                throw new ExportException("object already exported");
            }
            objTable.put(id, target);
            implTable.put(impl, target);
        }
    }

    private static void removeTarget(Target target) {
        ObjID id = target.getObjID();
        objTable.remove(id);
        implTable.remove(target.getImpl());
        target.markRemoved();
    }
}

