/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.security.AccessControlContext;
import java.security.AccessController;
import jeus.rmi.impl.server.Dispatcher;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.spec.server.ObjID;

public final class Target {
    private final ObjID id;
    private Remote strongImpl;
    private Dispatcher disp;
    private final Remote stub;
    private final AccessControlContext acc;
    private final ClassLoader ccl;
    private int callCount = 0;
    private boolean removed = false;
    private Transport exportedTransport = null;

    public Target(Remote impl, Dispatcher disp, Remote stub, ObjID id) {
        this.disp = disp;
        this.stub = stub;
        this.id = id;
        this.acc = AccessController.getContext();
        ClassLoader threadContextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader serverLoader = impl.getClass().getClassLoader();
        this.ccl = Target.checkLoaderAncestry(threadContextLoader, serverLoader) ? threadContextLoader : serverLoader;
        this.strongImpl = impl;
    }

    private static boolean checkLoaderAncestry(ClassLoader child, ClassLoader ancestor) {
        if (ancestor == null) {
            return true;
        }
        if (child == null) {
            return false;
        }
        for (ClassLoader parent = child; parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    public Remote getStub() {
        return this.stub;
    }

    ObjID getObjID() {
        return this.id;
    }

    public Dispatcher getDispatcher() {
        return this.disp;
    }

    AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    public ClassLoader getContextClassLoader() {
        return this.ccl;
    }

    public synchronized Remote getImpl() {
        return this.strongImpl;
    }

    public void setExportedTransport(Transport exportedTransport) {
        if (this.exportedTransport == null) {
            this.exportedTransport = exportedTransport;
        }
    }

    public Transport getExportedTransport() {
        return this.exportedTransport;
    }

    synchronized boolean unexport(boolean force) {
        if (force || this.callCount == 0 || this.disp == null) {
            this.disp = null;
            return true;
        }
        return false;
    }

    synchronized void markRemoved() {
        if (this.removed) {
            throw new AssertionError();
        }
        this.removed = true;
    }

    public synchronized void incrementCallCount() throws NoSuchObjectException {
        if (this.disp != null) {
            ++this.callCount;
        } else {
            throw new NoSuchObjectException("object not accepting new calls");
        }
    }

    public synchronized void decrementCallCount() {
        if (--this.callCount < 0) {
            throw new Error("internal error: call count less than zero");
        }
    }
}

