/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlContext;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.server.Dispatcher;
import jeus.rmi.impl.server.UnicastServerRef;
import jeus.rmi.impl.transport.ObjectTable;
import jeus.rmi.impl.transport.StreamRemoteCall;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.spec.RemoteCall;
import jeus.rmi.spec.server.LogStream;
import jeus.rmi.spec.server.ObjID;
import jeus.rmi.spec.server.RemoteServer;
import jeus.util.properties.JeusRMIProperties;

public abstract class Transport {
    static final int logLevel = LogStream.parseLevel(JeusRMIProperties.TRANSPORT_LOG_LEVEL);
    public static final Log transportLog = Log.getLog("jeus.rmi.transport.misc", "transport", logLevel);

    public void exportObject(Target target) throws RemoteException {
        ObjectTable.putTarget(target);
    }

    protected abstract void checkAcceptPermission(AccessControlContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serviceCall(RemoteCall call) throws IOException {
        boolean notUsed;
        block23: {
            notUsed = false;
            try {
                Remote impl;
                long op;
                ObjID id;
                ObjectInput objInput = null;
                int num = -1;
                try {
                    DataInput dis = call.getDataInputStream();
                    id = ObjID.read(dis);
                    op = dis.readLong();
                }
                catch (IOException e) {
                    notUsed = true;
                    throw new MarshalException("unable to read objID", e);
                }
                catch (Exception e) {
                    notUsed = true;
                    throw new UnexpectedException("Unable to get information from CallContext", e);
                }
                Target target = ObjectTable.getTarget(id);
                if (target == null || (impl = target.getImpl()) == null) {
                    notUsed = true;
                    throw new NoSuchObjectException("no such object in table");
                }
                Dispatcher disp = target.getDispatcher();
                target.incrementCallCount();
                try {
                    transportLog.log(Log.VERBOSE, "call dispatcher");
                    ClassLoader ccl = target.getContextClassLoader();
                    Thread t = Thread.currentThread();
                    ClassLoader savedCcl = t.getContextClassLoader();
                    try {
                        t.setContextClassLoader(ccl);
                        disp.dispatch(impl, call, objInput, num, op);
                    }
                    finally {
                        t.setContextClassLoader(savedCcl);
                    }
                    target.decrementCallCount();
                }
                catch (IOException ex) {
                    boolean bl;
                    try {
                        bl = false;
                        target.decrementCallCount();
                    }
                    catch (Throwable throwable) {
                        try {
                            target.decrementCallCount();
                            throw throwable;
                        }
                        catch (RemoteException e) {
                            if (UnicastServerRef.callLog.isLoggable(Log.BRIEF)) {
                                String clientHost = "";
                                try {
                                    clientHost = "[" + RemoteServer.getClientHost() + "] ";
                                }
                                catch (ServerNotActiveException ex2) {
                                    // empty catch block
                                }
                                String message = clientHost + "exception: ";
                                UnicastServerRef.callLog.log(Log.BRIEF, message, e);
                            }
                            try {
                                ((StreamRemoteCall)call).setServerException(e);
                                UnicastServerRef.clearStackTraces(e);
                                call.releaseOutputStream();
                                break block23;
                            }
                            catch (IOException ie) {
                                boolean bl2 = false;
                                call.releaseInputStream();
                                return bl2;
                            }
                        }
                    }
                    call.releaseInputStream();
                    return bl;
                }
            }
            finally {
                call.releaseInputStream();
            }
        }
        return !notUsed;
    }
}

