/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.net;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Vector;
import jeus.io.impl.blocking.util.ByteArrayInputStream;
import jeus.io.impl.blocking.util.ByteArrayOutputStream;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.impl.nio.util.ByteBufferOutputStream;
import jeus.net.ReplyListener;
import jeus.net.SocketStream;
import jeus.net.helper.MsgSync;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.server.MarshalInputStream;
import jeus.rmi.impl.server.MarshalOutputStream;
import jeus.rmi.impl.transport.Channel;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.net.help.RMIPropertiesConstant;
import jeus.rmi.impl.transport.proxy.RMISocketInfo;
import jeus.rmi.impl.transport.support.ConnectionSupport;
import jeus.util.JeusException;
import jeus.util.properties.JeusRMIProperties;

public class JeusConnection
extends ConnectionSupport {
    private SocketStream socketStream;
    private long roundtrip = 5L;
    OutputStream baos = new ByteArrayOutputStream();
    ByteArrayInputStream bais;
    private DataOutput dout;
    private DataInput din;
    protected ObjectOutputStream oos = null;
    protected ObjectInputStream ois = null;
    public static final int NORMAL = 1;
    public static final int REQUEST = 2;
    public static final int REPLY = 3;
    public static final int REPLY_REQUEST = 4;
    private static Hashtable activeConnections = new Hashtable();
    private static final byte[] PING_MSG = new byte[]{2, 82};

    public JeusConnection(SocketStream socektStream) {
        this.socketStream = socektStream;
        this.baos = RMIPropertiesConstant.useChannel ? new ByteBufferOutputStream(JeusRMIProperties.BUFFER_SIZE) : new ByteArrayOutputStream();
        JeusConnection.addConnectionToActiveList(socektStream, this);
    }

    public SocketStream getSocketStream() {
        return this.socketStream;
    }

    public boolean isReusable() {
        Socket socket = this.socketStream.getSocket();
        if (socket != null && socket instanceof RMISocketInfo) {
            return ((RMISocketInfo)((Object)socket)).isReusable();
        }
        return true;
    }

    public void close() throws IOException {
        Transport.transportLog.log(Log.BRIEF, "close connection");
        Vector connectionsWithSameSocketStream = (Vector)activeConnections.get(this.getSocketStream());
        if (connectionsWithSameSocketStream == null || connectionsWithSameSocketStream.size() == 0) {
            this.socketStream.destroy();
        }
        this.closeInternal();
    }

    public void closeInternal() throws IOException {
        if (this.baos != null) {
            ByteBuffer buffer;
            if (RMIPropertiesConstant.useChannel && (buffer = ((ByteBufferOutputStream)this.baos).getByteBuffer()) != null) {
                ByteBufferCreator.freeByteBuffer((ByteBuffer)buffer);
            }
            this.baos.close();
        }
        if (this.bais != null) {
            this.bais.close();
        }
        if (this.oos != null) {
            this.oos.close();
        }
        if (this.ois != null) {
            this.ois.close();
        }
    }

    public ObjectOutput getObjectOutput() throws IOException {
        if (this.oos == null) {
            this.oos = new MarshalOutputStream(this.baos);
        } else {
            this.oos.reset();
        }
        return this.oos;
    }

    public void setByteArrayInputStream(byte[] messageArray) {
        if (this.bais == null) {
            this.bais = new ByteArrayInputStream();
        }
        this.bais.setByteArray(messageArray);
    }

    public ObjectInput getObjectInput(ClassLoader _cl) throws IOException {
        if (this.bais == null) {
            throw new JeusException(" set ByteArrayInputStream before get ObjectInput");
        }
        if (this.ois == null) {
            this.ois = new MarshalInputStream((InputStream)this.bais, _cl);
        } else {
            ((MarshalInputStream)this.ois).setFirstClassLoader(_cl);
        }
        return this.ois;
    }

    public DataOutput getDataOutput() throws IOException {
        if (this.dout == null) {
            this.dout = new DataOutputStream(this.baos);
        }
        return this.dout;
    }

    public DataInput getDataInput() throws IOException {
        if (this.bais == null) {
            throw new JeusException(" set ByteArrayInputStream before get ObjectInput");
        }
        this.din = new DataInputStream((InputStream)this.bais);
        return this.din;
    }

    public boolean isDead() {
        long start = System.currentTimeMillis();
        if (this.roundtrip > 0L && start < this.lastuse + this.roundtrip) {
            return false;
        }
        MsgSync sync = new MsgSync(JeusRMIProperties.WAIT_TIME_OUT);
        byte[] returnValue = new byte[1];
        try {
            this.socketStream.write(PING_MSG, (ReplyListener)sync);
            returnValue = (byte[])sync.waitReply();
        }
        catch (IOException e) {
            Transport.transportLog.log(Log.VERBOSE, "exception: ", e);
            Transport.transportLog.log(Log.BRIEF, "server ping failed");
            return true;
        }
        if (returnValue[0] == 83) {
            this.roundtrip = (System.currentTimeMillis() - start) * 2L;
            return false;
        }
        return true;
    }

    public void write() throws IOException {
        try {
            if (RMIPropertiesConstant.useChannel) {
                this.socketStream.write((Object)((ByteBufferOutputStream)this.baos).getByteBuffer());
            } else {
                this.socketStream.write(((ByteArrayOutputStream)this.baos).toByteArray());
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.resetOutputStream();
        }
    }

    public void writeReply() throws IOException {
        try {
            if (RMIPropertiesConstant.useChannel) {
                this.socketStream.writeReply((Object)((ByteBufferOutputStream)this.baos).getByteBuffer());
            } else {
                this.socketStream.writeReply(((ByteArrayOutputStream)this.baos).toByteArray());
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.resetOutputStream();
        }
    }

    public void write(ReplyListener listener) throws IOException {
        try {
            if (RMIPropertiesConstant.useChannel) {
                this.socketStream.write((Object)((ByteBufferOutputStream)this.baos).getByteBuffer(), listener);
            } else {
                this.socketStream.write(((ByteArrayOutputStream)this.baos).toByteArray(), listener);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.resetOutputStream();
        }
    }

    protected void resetOutputStream() {
        if (this.baos != null) {
            if (RMIPropertiesConstant.useChannel) {
                ((ByteBufferOutputStream)this.baos).close();
            } else {
                ((ByteArrayOutputStream)this.baos).reset();
            }
        }
    }

    public void intializeBuffer(int bufferType) {
        ByteBuffer buffer = ((ByteBufferOutputStream)this.baos).getByteBuffer();
        if (buffer == null) {
            buffer = ((ByteBufferOutputStream)this.baos).setByteBuffer(JeusRMIProperties.BUFFER_SIZE);
        }
        switch (bufferType) {
            case 1: {
                buffer.position(8);
                break;
            }
            case 2: {
                buffer.position(20);
                break;
            }
            case 3: {
                buffer.position(20);
                break;
            }
            case 4: {
                buffer.position(24);
                break;
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    public void releaseInputStream() throws IOException {
    }

    public OutputStream getOutputStream() throws IOException {
        return this.baos;
    }

    public Channel getChannel() {
        return null;
    }

    public void releaseOutputStream() throws IOException {
    }

    public static synchronized void addConnectionToActiveList(SocketStream socektStream, JeusConnection conn) {
        Vector<JeusConnection> connections = (Vector<JeusConnection>)activeConnections.get(socektStream);
        if (connections == null) {
            connections = new Vector<JeusConnection>();
            activeConnections.put(socektStream, connections);
        }
        connections.add(conn);
    }

    public static synchronized void removeConnectionToActiveList(SocketStream socektStream, JeusConnection conn) {
        Vector connections = (Vector)activeConnections.get(socektStream);
        if (connections != null) {
            connections.remove(conn);
            if (connections.isEmpty()) {
                activeConnections.remove(socektStream);
            }
        }
    }
}

