/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.net.help;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Map;
import javax.net.ssl.SSLContext;
import jeus.io.Acceptor;
import jeus.io.Connector;
import jeus.io.SocketListener;
import jeus.io.helper.IOComponentCreator;
import jeus.io.impl.blocking.SocketAcceptor;
import jeus.io.impl.nio.ChannelAcceptor;
import jeus.rmi.impl.transport.net.help.RMISocketConnector;
import jeus.rmi.impl.transport.support.EndpointSupport;

public class RMIIOComponentCreator
extends IOComponentCreator {
    private RMIClientSocketFactory csf;
    private RMIServerSocketFactory ssf;

    public RMIIOComponentCreator(int selectorType, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, String creatorName, int expectedMaxClient) {
        super(selectorType, creatorName, expectedMaxClient);
        this.csf = csf;
        this.ssf = ssf;
    }

    public Acceptor createAcceptor(int port, SocketListener listener, SSLContext sslContext, int backlog, InetAddress listenHost, boolean reuseAddress) throws IOException {
        if (this.ssf == null) {
            this.ssf = EndpointSupport.chooseFactory();
        }
        ServerSocket server = this.ssf.createServerSocket(port);
        switch (this.selectorType) {
            case 1: 
            case 3: {
                return new ChannelAcceptor(server, listener);
            }
            case 2: {
                return new SocketAcceptor(server, listener);
            }
        }
        throw new RuntimeException();
    }

    public Connector createConnector(SSLContext sslContext, Map sslProperties) {
        if (this.csf == null) {
            this.csf = EndpointSupport.chooseFactory();
        }
        switch (this.selectorType) {
            case 1: 
            case 3: {
                return new RMISocketConnector(this.csf, this.selectorType);
            }
            case 2: {
                return new RMISocketConnector(this.csf, this.selectorType);
            }
        }
        throw new RuntimeException();
    }

    public Connector createOnePortConnector(SSLContext sslContext) {
        return new RMISocketConnector(this.csf, this.selectorType);
    }
}

