/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.proxy;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import jeus.rmi.impl.transport.proxy.HttpInputStream;
import jeus.rmi.impl.transport.proxy.HttpOutputStream;
import jeus.rmi.impl.transport.proxy.RMISocketInfo;
import jeus.rmi.impl.transport.proxy.WrappedSocket;

public class HttpReceiveSocket
extends WrappedSocket
implements RMISocketInfo {
    private boolean headerSent = false;

    public HttpReceiveSocket(Socket socket, InputStream in, OutputStream out) throws IOException {
        super(socket, in, out);
        this.in = new HttpInputStream(in != null ? in : socket.getInputStream());
        this.out = out != null ? out : socket.getOutputStream();
    }

    public boolean isReusable() {
        return false;
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.headerSent) {
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeBytes("HTTP/1.0 200 OK\r\n");
            dos.flush();
            this.headerSent = true;
            this.out = new HttpOutputStream(this.out);
        }
        return this.out;
    }

    public synchronized void close() throws IOException {
        this.getOutputStream().close();
        this.socket.close();
    }

    public String toString() {
        return "HttpReceive" + this.socket.toString();
    }
}

