/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.proxy;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.transport.proxy.HttpSendInputStream;
import jeus.rmi.impl.transport.proxy.HttpSendOutputStream;
import jeus.rmi.impl.transport.proxy.RMIMasterSocketFactory;
import jeus.rmi.impl.transport.proxy.RMISocketInfo;
import jeus.util.properties.JeusNetPropertyValues;
import sun.security.action.GetPropertyAction;

class HttpSendSocket
extends Socket
implements RMISocketInfo {
    protected String host;
    protected int port;
    protected URL url;
    protected URLConnection conn = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected HttpSendInputStream inNotifier;
    protected HttpSendOutputStream outNotifier;
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    public HttpSendSocket(String host, int port, URL url) throws IOException {
        super((SocketImpl)null);
        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "host = " + host + ", port = " + port + ", url = " + url);
        }
        this.host = host;
        this.port = port;
        this.url = url;
        this.inNotifier = new HttpSendInputStream(null, this);
        this.outNotifier = new HttpSendOutputStream(this.writeNotify(), this);
    }

    public HttpSendSocket(String host, int port) throws IOException {
        this(host, port, new URL("http", host, port, "/"));
    }

    public HttpSendSocket(InetAddress address, int port) throws IOException {
        this(address.getHostName(), port);
    }

    public boolean isReusable() {
        return false;
    }

    public synchronized OutputStream writeNotify() throws IOException {
        if (this.conn != null) {
            throw new IOException("attempt to write on HttpSendSocket after request has been sent");
        }
        this.conn = this.url.openConnection();
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setRequestProperty("Content-type", "application/octet-stream");
        this.inNotifier.deactivate();
        this.in = null;
        this.out = this.conn.getOutputStream();
        return this.out;
    }

    public synchronized InputStream readNotify() throws IOException {
        RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "sending request and activating input stream");
        this.outNotifier.deactivate();
        this.out.close();
        this.out = null;
        try {
            this.in = this.conn.getInputStream();
        }
        catch (IOException e) {
            RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "failed to get input stream, exception: ", e);
            throw new IOException("HTTP request failed");
        }
        String contentType = this.conn.getContentType();
        if (contentType == null || !this.conn.getContentType().equals("application/octet-stream")) {
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                String message = contentType == null ? "missing content type in response" + this.lineSeparator : "invalid content type in response: " + contentType + this.lineSeparator;
                message = message + "HttpSendSocket.readNotify: response body: ";
                try {
                    String line;
                    DataInputStream din = new DataInputStream(this.in);
                    while ((line = din.readLine()) != null) {
                        message = message + line + this.lineSeparator;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, message);
            }
            throw new IOException("HTTP request failed");
        }
        return this.in;
    }

    public InetAddress getInetAddress() {
        try {
            return JeusNetPropertyValues.getByName((String)this.host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        return JeusNetPropertyValues.getLocalInetAddress();
    }

    public int getPort() {
        return this.port;
    }

    public int getLocalPort() {
        return -1;
    }

    public InputStream getInputStream() throws IOException {
        return this.inNotifier;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outNotifier;
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    public void setSoLinger(boolean on, int val) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
    }

    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    public String toString() {
        return "HttpSendSocket[host=" + this.host + ",port=" + this.port + ",url=" + this.url + "]";
    }
}

