/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.support;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import java.util.Map;
import jeus.rmi.impl.transport.Endpoint;
import jeus.rmi.spec.server.RMISocketFactory;

public abstract class EndpointSupport
implements Endpoint {
    protected String host;
    protected int port;
    protected final RMIClientSocketFactory csf;
    protected final RMIServerSocketFactory ssf;
    protected static final Map localEndpoints = new HashMap(3);
    protected static final int FORMAT_HOST_PORT = 0;
    protected static final int FORMAT_HOST_PORT_FACTORY = 1;
    static final RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();

    public EndpointSupport(String host, int port) {
        this(host, port, null, null);
    }

    public EndpointSupport(String host, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        if (host == null) {
            host = "";
        }
        this.host = host;
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.csf;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public String toString() {
        return "[" + this.host + ":" + this.port + (this.ssf != null ? "," + this.ssf : "") + (this.csf != null ? "," + this.csf : "") + "]";
    }

    public int hashCode() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof EndpointSupport) {
            EndpointSupport ep = (EndpointSupport)obj;
            if (this.port != ep.port || !this.host.equals(ep.host)) {
                return false;
            }
            if (this.csf == null ^ ep.csf == null || this.ssf == null ^ ep.ssf == null) {
                return false;
            }
            if (!(this.csf == null || this.csf.getClass() == ep.csf.getClass() && this.csf.equals(ep.csf))) {
                return false;
            }
            return this.ssf == null || this.ssf.getClass() == ep.ssf.getClass() && this.ssf.equals(ep.ssf);
        }
        return false;
    }

    public static RMISocketFactory chooseFactory() {
        RMISocketFactory sf = RMISocketFactory.getSocketFactory();
        if (sf == null) {
            sf = defaultSocketFactory;
        }
        return sf;
    }

    public void write(ObjectOutput out) throws IOException {
        if (this.csf == null) {
            out.writeByte(0);
            out.writeUTF(this.host);
            out.writeInt(this.port);
        } else {
            out.writeByte(1);
            out.writeUTF(this.host);
            out.writeInt(this.port);
            out.writeObject(this.csf);
        }
    }

    public void writeHostPortFormat(DataOutput out) throws IOException {
        if (this.csf != null) {
            throw new InternalError("TCPServerEndpoint.writeHostPortFormat: called for endpoint with non-null socket factory");
        }
        out.writeUTF(this.host);
        out.writeInt(this.port);
    }
}

