/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.tcp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Map;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.transport.ClientEndpoint;
import jeus.rmi.impl.transport.ClientEndpointKey;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.tcp.TCPChannel;

public class TCPClientEndpoint
extends ClientEndpoint {
    public TCPClientEndpoint(String host, int port) {
        this(host, port, null);
    }

    public TCPClientEndpoint(String host, int port, RMIClientSocketFactory csf) {
        super(host, port, csf, null);
        this.channel = new TCPChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TCPClientEndpoint getLocalEndpoint(String host, int port, RMIClientSocketFactory csf) {
        TCPClientEndpoint endpoint;
        Map map = localEndpoints;
        synchronized (map) {
            ClientEndpointKey key = new ClientEndpointKey(host, port, csf);
            endpoint = (TCPClientEndpoint)localEndpoints.get(key);
            if (endpoint == null) {
                endpoint = new TCPClientEndpoint(host, port, csf);
                localEndpoints.put(key, endpoint);
            }
        }
        return endpoint;
    }

    public Socket newSocket() throws RemoteException {
        Socket socket;
        if (Transport.transportLog.isLoggable(Log.VERBOSE)) {
            Transport.transportLog.log(Log.VERBOSE, "opening socket to " + this);
        }
        try {
            RMIClientSocketFactory clientFactory = this.csf;
            if (clientFactory == null) {
                clientFactory = TCPClientEndpoint.chooseFactory();
            }
            socket = clientFactory.createSocket(this.host, this.port);
        }
        catch (java.net.UnknownHostException e) {
            throw new UnknownHostException("Unknown host: " + this.host, e);
        }
        catch (ConnectException e) {
            throw new java.rmi.ConnectException("Connection refused to host: " + this.host + ": " + this.port, e);
        }
        catch (IOException e) {
            try {
                this.shedConnectionCaches();
            }
            catch (OutOfMemoryError mem) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ConnectIOException("Exception creating connection to: " + this.host, e);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            socket.setKeepAlive(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return socket;
    }

    public void shedConnectionCaches() {
        ((TCPChannel)this.channel).shedCache();
    }
}

