/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.tcp;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import jeus.rmi.impl.transport.tcp.TCPChannel;
import jeus.rmi.impl.transport.tcp.TCPConnection;
import jeus.rmi.impl.transport.tcp.TCPConnection1;
import jeus.rmi.impl.transport.tcp.TCPConnection2;
import jeus.rmi.impl.transport.tcp.TCPConnection3;
import jeus.rmi.impl.transport.tcp.TCPConnection4;
import jeus.rmi.impl.transport.tcp.TCPConnection5;
import jeus.rmi.impl.transport.tcp.TCPConnection6;
import jeus.rmi.impl.transport.tcp.TCPConnection7;
import jeus.rmi.impl.transport.tcp.TCPConnection8;
import jeus.util.properties.JeusRMIProperties;

public class TCPConnectionFactory {
    public static int ObjInOutType = JeusRMIProperties.TCP_OBJECT_STREAM_TYPE;
    public static int objResetCount = JeusRMIProperties.TCP_OBJECT_STREAM_RESET_COUNT;
    public static boolean ignoreClassAnnotation = JeusRMIProperties.IGNORE_CLASS_ANNOTATION;

    public static TCPConnection createTCPConnection(TCPChannel ch, Socket s, InputStream in, OutputStream out) {
        switch (ObjInOutType) {
            case 1: {
                return new TCPConnection1(ch, s, in, out);
            }
            case 2: {
                return new TCPConnection2(ch, s, in, out);
            }
            case 3: {
                return new TCPConnection3(ch, s, in, out);
            }
            case 4: {
                return new TCPConnection4(ch, s, in, out);
            }
            case 5: {
                return new TCPConnection5(ch, s, in, out);
            }
            case 6: {
                return new TCPConnection6(ch, s, in, out);
            }
            case 7: {
                return new TCPConnection7(ch, s, in, out);
            }
            case 8: {
                return new TCPConnection8(ch, s, in, out);
            }
        }
        return null;
    }

    public static TCPConnection createTCPConnection(TCPChannel ch, InputStream in, OutputStream out) {
        switch (ObjInOutType) {
            case 1: {
                return new TCPConnection1(ch, in, out);
            }
            case 2: {
                return new TCPConnection2(ch, in, out);
            }
            case 3: {
                return new TCPConnection3(ch, in, out);
            }
            case 4: {
                return new TCPConnection4(ch, in, out);
            }
            case 5: {
                return new TCPConnection5(ch, in, out);
            }
            case 6: {
                return new TCPConnection6(ch, in, out);
            }
            case 7: {
                return new TCPConnection7(ch, in, out);
            }
            case 8: {
                return new TCPConnection8(ch, in, out);
            }
        }
        return null;
    }

    public static TCPConnection createTCPConnection(TCPChannel ch, Socket s) {
        switch (ObjInOutType) {
            case 1: {
                return new TCPConnection1(ch, s);
            }
            case 2: {
                return new TCPConnection2(ch, s);
            }
            case 3: {
                return new TCPConnection3(ch, s);
            }
            case 4: {
                return new TCPConnection4(ch, s);
            }
            case 5: {
                return new TCPConnection5(ch, s);
            }
            case 6: {
                return new TCPConnection6(ch, s);
            }
            case 7: {
                return new TCPConnection7(ch, s);
            }
            case 8: {
                return new TCPConnection8(ch, s);
            }
        }
        return null;
    }

    static {
        if (ObjInOutType < 1 || ObjInOutType > 8) {
            ObjInOutType = 2;
        }
    }
}

