/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.security.AccessControlContext;
import java.util.WeakHashMap;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.transport.Connection;
import jeus.rmi.impl.transport.StreamRemoteCall;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.tcp.TCPConnection;
import jeus.rmi.impl.transport.tcp.TCPConnectionFactory;
import jeus.rmi.impl.transport.tcp.TCPServerEndpoint;
import jeus.rmi.impl.transport.tcp.TCPTransport;
import jeus.util.properties.JeusRMIProperties;
import sun.rmi.transport.proxy.HttpReceiveSocket;

public final class TCPConnectionHandler
implements Runnable {
    private static final int connectionReadTimeout = JeusRMIProperties.SERVER_READ_TO;
    private static final int POST = 1347375956;
    private AccessControlContext okContext;
    private WeakHashMap authCache;
    private SecurityManager cacheSecurityManager = null;
    private Socket socket;
    private String remoteHost;
    int remotePort;
    TCPTransport tcpTransport;
    private int port;

    TCPConnectionHandler(TCPTransport _tcpTransport, Socket socket) {
        this.tcpTransport = _tcpTransport;
        this.socket = socket;
    }

    String getClientHost() {
        return this.remoteHost;
    }

    void checkAcceptPermission(SecurityManager sm, AccessControlContext acc) {
        if (sm != this.cacheSecurityManager) {
            this.okContext = null;
            this.authCache = new WeakHashMap();
            this.cacheSecurityManager = sm;
        }
        if (acc.equals(this.okContext) || this.authCache.containsKey(acc)) {
            return;
        }
        InetAddress addr = this.socket.getInetAddress();
        String host = addr != null ? addr.getHostAddress() : "*";
        sm.checkAccept(host, this.socket.getPort());
        this.authCache.put(acc, new SoftReference<AccessControlContext>(acc));
        this.okContext = acc;
    }

    private void setSocketInfo(TCPServerEndpoint endpoint) {
        InetAddress clientAddr = this.socket.getInetAddress();
        this.remoteHost = clientAddr != null ? clientAddr.getHostAddress() : "0.0.0.0";
        this.remotePort = this.socket.getPort();
        if (Transport.transportLog.isLoggable(Log.VERBOSE)) {
            this.port = endpoint.getPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        TCPServerEndpoint endpoint = (TCPServerEndpoint)this.tcpTransport.getEndpoint();
        this.setSocketInfo(endpoint);
        try {
            this.socket.setTcpNoDelay(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (connectionReadTimeout > 0) {
                this.socket.setSoTimeout(connectionReadTimeout);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            InputStream sockIn = this.socket.getInputStream();
            InputStream bufIn = sockIn.markSupported() ? sockIn : new BufferedInputStream(sockIn);
            bufIn.mark(4);
            DataInputStream in = new DataInputStream(bufIn);
            int magic = in.readInt();
            if (magic == 1347375956) {
                Transport.transportLog.log(sun.rmi.runtime.Log.BRIEF, "decoding HTTP-wrapped call");
                bufIn.reset();
                try {
                    this.socket = new HttpReceiveSocket(this.socket, bufIn, null);
                    this.remoteHost = "0.0.0.0";
                    sockIn = this.socket.getInputStream();
                    bufIn = new BufferedInputStream(sockIn);
                    in = new DataInputStream(bufIn);
                    magic = in.readInt();
                }
                catch (IOException e) {
                    throw new RemoteException("Error HTTP-unwrapping call", e);
                }
            }
            short version = in.readShort();
            if (magic != 1246907721 || version != 2) {
                TCPConnectionHandler.closeSocket(this.socket);
                return;
            }
            OutputStream sockOut = this.socket.getOutputStream();
            BufferedOutputStream bufOut = new BufferedOutputStream(sockOut);
            DataOutputStream out = new DataOutputStream(bufOut);
            if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                Transport.transportLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + this.remotePort + "]");
            }
            byte protocol = in.readByte();
            switch (protocol) {
                case 76: {
                    TCPConnection conn = TCPConnectionFactory.createTCPConnection(null, this.socket, bufIn, bufOut);
                    this.handleMessages(conn, false);
                    return;
                }
                case 75: {
                    out.writeByte(78);
                    out.flush();
                    TCPConnection conn = TCPConnectionFactory.createTCPConnection(null, this.socket, bufIn, bufOut);
                    this.handleMessages(conn, true);
                    return;
                }
                default: {
                    out.writeByte(79);
                    out.flush();
                    return;
                }
            }
        }
        catch (IOException e) {
            Transport.transportLog.log(Log.BRIEF, "terminated with exception:", e);
            return;
        }
        finally {
            TCPConnectionHandler.closeSocket(this.socket);
        }
    }

    private static void closeSocket(Socket sock) {
        try {
            sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessages(Connection conn, boolean persistent) {
        int port = this.tcpTransport.getEndpoint().getPort();
        try {
            DataInputStream in = (DataInputStream)conn.getDataInput();
            block18: do {
                int op;
                if ((op = in.read()) == -1) {
                    break;
                }
                switch (op) {
                    case 80: {
                        StreamRemoteCall call = new StreamRemoteCall(conn);
                        if (Transport.serviceCall(call)) continue block18;
                        return;
                    }
                    case 82: {
                        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                        out.writeByte(83);
                        conn.releaseOutputStream();
                        break;
                    }
                    default: {
                        throw new IOException("unknown transport op " + op);
                    }
                }
            } while (persistent);
        }
        catch (IOException e) {
            if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                Transport.transportLog.log(Log.BRIEF, "(port " + port + ") exception: ", e);
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (IOException ex) {}
        }
    }
}

