/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.tcp;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.ServerSocket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.util.MissingResourceException;
import jeus.rmi.impl.runtime.GetThreadPoolAction;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.runtime.NewThreadAction;
import jeus.rmi.impl.runtime.ThreadPool;
import jeus.rmi.impl.transport.ServerEndpoint;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.impl.transport.support.TransportSupport;
import jeus.rmi.impl.transport.tcp.TCPConnectionHandler;
import jeus.rmi.impl.transport.tcp.TCPServerEndpoint;
import jeus.rmi.spec.server.RMIFailureHandler;
import jeus.rmi.spec.server.RMISocketFactory;
import jeus.util.properties.JeusRMIProperties;

public final class TCPTransport
extends TransportSupport
implements Runnable {
    private static int threadNum = 0;
    private ServerSocket server = null;
    public static final boolean useThreadPool = JeusRMIProperties.USE_THREAD_POOL;
    public static ThreadPool threadPool = null;
    private transient long acceptFailureTime = 0L;
    private transient int acceptFailureCount;

    protected TCPTransport(ServerEndpoint ep) {
        super(ep);
    }

    public void exportObject(Target target) throws RemoteException {
        this.listen();
        target.setExportedTransport(this);
        super.exportObject(target);
    }

    private synchronized void listen() throws RemoteException {
        int port = this.ep.getPort();
        if (this.server == null) {
            if (transportLog.isLoggable(Log.BRIEF)) {
                transportLog.log(Log.BRIEF, "(port " + port + ") create server socket");
            }
            try {
                this.server = ((TCPServerEndpoint)this.ep).newServerSocket();
                Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "TCP Accept-" + port, true));
                t.start();
            }
            catch (BindException e) {
                throw new ExportException("Port already in use: " + port, e);
            }
            catch (IOException e) {
                throw new ExportException("Listen failed on port: " + port, e);
            }
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkListen(port);
            }
        }
    }

    private synchronized boolean continueAfterAcceptFailure(Throwable t) {
        boolean f;
        RMIFailureHandler fh = RMISocketFactory.getFailureHandler();
        if (fh != null) {
            f = t instanceof Exception ? fh.failure((Exception)t) : fh.failure(new InvocationTargetException(t));
        } else {
            int NFAIL = 10;
            int NMSEC = 5000;
            long now = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || now - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = now;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ign) {
                        // empty catch block
                    }
                }
            }
            f = true;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        if (TCPTransport.transportLog.isLoggable(Log.BRIEF)) {
            TCPTransport.transportLog.log(Log.BRIEF, "listening on port " + this.getEndpoint().getPort());
        }
        if (TCPTransport.useThreadPool && TCPTransport.threadPool == null) {
            TCPTransport.threadPool = GetThreadPoolAction.getUserThreadPool();
        }
        while (true) {
            if ((myServer = this.server) == null) {
                return;
            }
            acceptFailure /* !! */  = null;
            try {
                socket = myServer.accept();
                if (TCPTransport.useThreadPool) {
                    TCPTransport.threadPool.execute(new TCPConnectionHandler(this, socket), "TCP Connection(" + ++TCPTransport.threadNum + ")");
                    continue;
                }
                t = (Thread)AccessController.doPrivileged(new NewThreadAction(new TCPConnectionHandler(this, socket), "TCP Connection(" + ++TCPTransport.threadNum + ")", true, true));
                t.start();
                continue;
            }
            catch (IOException e) {
                acceptFailure /* !! */  = e;
            }
            catch (RuntimeException e) {
                acceptFailure /* !! */  = e;
            }
            catch (Error e) {
                acceptFailure /* !! */  = e;
            }
            finally {
                if (acceptFailure /* !! */  == null) continue;
                if (acceptFailure /* !! */  instanceof IOException || acceptFailure /* !! */  instanceof OutOfMemoryError || acceptFailure /* !! */  instanceof NoClassDefFoundError || acceptFailure /* !! */  instanceof MissingResourceException || acceptFailure /* !! */  instanceof SecurityException) {
                    if (!this.continueAfterAcceptFailure(acceptFailure /* !! */ )) ** break;
                    continue;
                    return;
                }
                if (acceptFailure /* !! */  instanceof RuntimeException) {
                    throw (RuntimeException)acceptFailure /* !! */ ;
                }
                throw (Error)acceptFailure /* !! */ ;
            }
            break;
        }
    }

    public static String getClientHost() throws ServerNotActiveException {
        return null;
    }
}

