/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.rmic;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import jeus.rmi.rmic.BatchEnvironment;
import jeus.rmi.rmic.Constants;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;

public class ClassUtils
implements Constants {
    public static File getOutputDirectoryFor(Identifier theClass, File rootDir, BatchEnvironment env) {
        String className;
        File outputDir = null;
        String qualifiedClassName = className = theClass.getFlatName().toString().replace('.', '$');
        String packagePath = null;
        String packageName = theClass.getQualifier().toString();
        if (packageName.length() > 0) {
            qualifiedClassName = packageName + "." + className;
            packagePath = packageName.replace('.', File.separatorChar);
        }
        if (rootDir != null) {
            if (packagePath != null) {
                outputDir = new File(rootDir, packagePath);
                ClassUtils.ensureDirectory(outputDir, env);
            } else {
                outputDir = rootDir;
            }
        } else {
            outputDir = ClassUtils.packageDirectory(qualifiedClassName, env.getClassPath(), false);
            if (outputDir == null) {
                String workingDirPath = System.getProperty("user.dir");
                File workingDir = new File(workingDirPath);
                if (packagePath == null) {
                    outputDir = workingDir;
                } else if (ClassUtils.directoryInPath(workingDirPath, env.getClassPath().toString())) {
                    outputDir = new File(workingDir, packagePath);
                    ClassUtils.ensureDirectory(outputDir, env);
                } else {
                    env.error(0L, "rmic.no.output.dir", qualifiedClassName);
                    throw new InternalError();
                }
            }
        }
        return outputDir;
    }

    private static void ensureDirectory(File dir, BatchEnvironment env) {
        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                env.error(0L, "rmic.cannot.create.dir", dir.getAbsolutePath());
                throw new InternalError();
            }
        }
    }

    public static File packageDirectory(String className, boolean requireFile) {
        ClassPath path = new ClassPath(System.getProperty("java.class.path"));
        File result = ClassUtils.packageDirectory(className, path, requireFile);
        try {
            path.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    public static File packageDirectory(String className, ClassPath path, boolean requireFile) {
        String packageName;
        ClassFile cls;
        int i;
        File result = ClassUtils.packageDirectory(className, path, ".class");
        if (result == null && (result = ClassUtils.packageDirectory(className, path, ".java")) == null && !requireFile && (i = className.lastIndexOf(46)) >= 0 && (cls = path.getDirectory((packageName = className.substring(0, i)).replace('.', File.separatorChar))) != null && !cls.isZipped()) {
            result = new File(cls.getPath());
        }
        return result;
    }

    private static boolean directoryInPath(String dirPath, String path) {
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        StringTokenizer st = new StringTokenizer(path, "\t\n\r" + File.pathSeparator);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (entry.endsWith(".zip") || entry.endsWith(".jar")) continue;
            if (entry.equals(".")) {
                return true;
            }
            if (!entry.endsWith(File.separator)) {
                entry = entry + File.separator;
            }
            if (!entry.equalsIgnoreCase(dirPath)) continue;
            return true;
        }
        return false;
    }

    private static File packageDirectory(String className, ClassPath path, String fileExt) {
        ClassFile cls = path.getFile(className.replace('.', File.separatorChar) + fileExt);
        if (cls != null && !cls.isZipped()) {
            File file = new File(cls.getPath());
            File dir = new File(file.getParent());
            return dir;
        }
        return null;
    }
}

