/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.spec;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.lang.reflect.Method;
import jeus.rmi.impl.transport.Connection;
import jeus.rmi.spec.ClientInterceptor;
import jeus.rmi.spec.ServerInterceptor;

public abstract class RemoteCall
implements ObjectOutput,
ObjectInput {
    protected boolean isSimpleParams;
    protected byte returnTypeNumber;
    protected boolean isVoidReturn;
    protected Method method;
    protected boolean resultStarted = false;
    protected Connection conn;
    protected ObjectInput in = null;
    protected ObjectOutput out = null;
    protected DataInput din = null;
    protected DataOutput dout = null;
    public final byte INT_Response_Type = 1;
    public int int_Response_Value;
    public final byte BOOLEAN_Response_Type = (byte)2;
    public boolean boolean_Response_Value;
    public final byte BYTE_Response_Type = (byte)3;
    public byte byte_Response_Value;
    public final byte CHAR_Response_Type = (byte)4;
    public char char_Response_Value;
    public final byte SHORT_Response_Type = (byte)5;
    public short short_Response_Value;
    public final byte LONG_Response_Type = (byte)6;
    public long long_Response_Value;
    public final byte FLOAT_Response_Type = (byte)7;
    public float float_Response_Value;
    public final byte DOUBLE_Response_Type = (byte)8;
    public double double_Response_Value;
    public final byte INT_ARRARY_Response_Type = (byte)9;
    public int[] int_ARRARY_Response_Value;
    public final byte BOOLEAN_ARRARY_Response_Type = (byte)10;
    public boolean[] boolean_ARRARY_Response_Value;
    public final byte BYTE_ARRARY_Response_Type = (byte)11;
    public byte[] byte_ARRARY_Response_Value;
    public final byte CHAR_ARRARY_Response_Type = (byte)12;
    public char[] char_ARRARY_Response_Value;
    public final byte SHORT_ARRARY_Response_Type = (byte)13;
    public short[] short_ARRARY_Response_Value;
    public final byte LONG_ARRARY_Response_Type = (byte)14;
    public long[] long_ARRARY_Response_Value;
    public final byte FLOAT_ARRARY_Response_Type = (byte)15;
    public float[] float_ARRARY_Response_Value;
    public final byte DOUBLE_ARRARY_Response_Type = (byte)16;
    public double[] double_ARRARY_Response_Value;
    public final byte STRING_Response_Type = (byte)17;
    public String string_Response_Value;
    public final byte OBJECT_Response_Type = (byte)18;
    public Object object_Response_Value;
    private ClientInterceptor clientInterceptor;
    private ServerInterceptor serverInterceptor;

    public void setClientIntercepter(ClientInterceptor _clientInterceptor) {
        if (_clientInterceptor != null) {
            this.clientInterceptor = _clientInterceptor;
        }
    }

    public void setServerIntercepter(ServerInterceptor _serverInterceptor) {
        if (_serverInterceptor != null) {
            this.serverInterceptor = _serverInterceptor;
        }
    }

    public boolean isSetClientIntercepter() {
        return this.clientInterceptor != null;
    }

    public boolean isSetServerIntercepter() {
        return this.serverInterceptor != null;
    }

    public ClientInterceptor getClientIntercepter() {
        return this.clientInterceptor;
    }

    public ServerInterceptor getServerIntercepter() {
        return this.serverInterceptor;
    }

    public ObjectOutput getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    public abstract ObjectOutput getOutputStream(boolean var1) throws IOException;

    public abstract DataOutput getDataOutputStream() throws IOException;

    public abstract void releaseOutputStream() throws IOException;

    public abstract ObjectInput getInputStream() throws IOException;

    public abstract DataInput getDataInputStream() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInputStream() throws IOException {
        try {
            this.conn.releaseInputStream();
        }
        finally {
            this.in = null;
        }
    }

    public abstract ObjectOutput getResultStream(boolean var1) throws IOException, StreamCorruptedException;

    public abstract void executeCall() throws Exception;

    public Connection getConnection() {
        return this.conn;
    }

    public void setInfo(Method _method, byte _returnTypeNumber, boolean voidReturn, boolean simpleParams) {
        this.method = _method;
        this.returnTypeNumber = _returnTypeNumber;
        this.isVoidReturn = voidReturn;
        this.isSimpleParams = simpleParams;
    }

    public void writeObject(Object obj) throws IOException {
        switch (this.returnTypeNumber) {
            case 9: {
                this.int_ARRARY_Response_Value = (int[])obj;
                break;
            }
            case 10: {
                this.boolean_ARRARY_Response_Value = (boolean[])obj;
                break;
            }
            case 11: {
                this.byte_ARRARY_Response_Value = (byte[])obj;
                break;
            }
            case 12: {
                this.char_ARRARY_Response_Value = (char[])obj;
                break;
            }
            case 13: {
                this.short_ARRARY_Response_Value = (short[])obj;
                break;
            }
            case 14: {
                this.long_ARRARY_Response_Value = (long[])obj;
                break;
            }
            case 15: {
                this.float_ARRARY_Response_Value = (float[])obj;
                break;
            }
            case 16: {
                this.double_ARRARY_Response_Value = (double[])obj;
                break;
            }
            case 17: {
                this.string_Response_Value = (String)obj;
                break;
            }
            default: {
                this.object_Response_Value = obj;
            }
        }
    }

    public void write(int b) throws IOException {
    }

    public void write(byte[] b) throws IOException {
    }

    public void write(byte[] b, int off, int len) throws IOException {
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public void writeBoolean(boolean v) throws IOException {
        this.boolean_Response_Value = v;
    }

    public void writeByte(int v) throws IOException {
        this.byte_Response_Value = (byte)v;
    }

    public void writeShort(int v) throws IOException {
        this.short_Response_Value = (short)v;
    }

    public void writeChar(int v) throws IOException {
        this.char_Response_Value = (char)v;
    }

    public void writeInt(int v) throws IOException {
        this.int_Response_Value = v;
    }

    public void writeLong(long v) throws IOException {
        this.long_Response_Value = v;
    }

    public void writeFloat(float v) throws IOException {
        this.float_Response_Value = v;
    }

    public void writeDouble(double v) throws IOException {
        this.double_Response_Value = v;
    }

    public void writeBytes(String s) throws IOException {
    }

    public void writeChars(String s) throws IOException {
    }

    public void writeUTF(String str) throws IOException {
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        switch (this.returnTypeNumber) {
            case 9: {
                return this.int_ARRARY_Response_Value;
            }
            case 10: {
                return this.boolean_ARRARY_Response_Value;
            }
            case 11: {
                return this.byte_ARRARY_Response_Value;
            }
            case 12: {
                return this.char_ARRARY_Response_Value;
            }
            case 13: {
                return this.short_ARRARY_Response_Value;
            }
            case 14: {
                return this.long_ARRARY_Response_Value;
            }
            case 15: {
                return this.float_ARRARY_Response_Value;
            }
            case 16: {
                return this.double_ARRARY_Response_Value;
            }
            case 17: {
                return this.string_Response_Value;
            }
        }
        return this.object_Response_Value;
    }

    public int read() throws IOException {
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return -1;
    }

    public long skip(long n) throws IOException {
        return -1L;
    }

    public int available() throws IOException {
        return -1;
    }

    public void readFully(byte[] b) throws IOException {
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
    }

    public int skipBytes(int n) throws IOException {
        return -1;
    }

    public boolean readBoolean() throws IOException {
        return this.boolean_Response_Value;
    }

    public byte readByte() throws IOException {
        return this.byte_Response_Value;
    }

    public int readUnsignedByte() throws IOException {
        return -1;
    }

    public short readShort() throws IOException {
        return this.short_Response_Value;
    }

    public int readUnsignedShort() throws IOException {
        return -1;
    }

    public char readChar() throws IOException {
        return this.char_Response_Value;
    }

    public int readInt() throws IOException {
        return this.int_Response_Value;
    }

    public long readLong() throws IOException {
        return this.long_Response_Value;
    }

    public float readFloat() throws IOException {
        return this.float_Response_Value;
    }

    public double readDouble() throws IOException {
        return this.double_Response_Value;
    }

    public String readLine() throws IOException {
        return null;
    }

    public String readUTF() throws IOException {
        return null;
    }

    public static void writeIntArray(DataOutput dout, int[] data) throws IOException {
        if (data == null) {
            dout.writeByte(0);
        } else {
            dout.writeByte(1);
            dout.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                int iVal = data[i];
                dout.writeInt(iVal);
            }
        }
    }

    public static int[] readIntArray(DataInput din) throws IOException {
        int[] value = null;
        byte isNull = din.readByte();
        if (isNull != 0) {
            int _length = din.readInt();
            value = new int[_length];
            for (int i = 0; i < _length; ++i) {
                value[i] = din.readInt();
            }
        }
        return value;
    }

    public static void writeBooleanArray(DataOutput dout, boolean[] data) throws IOException {
        if (data == null) {
            dout.writeByte(0);
        } else {
            dout.writeByte(1);
            dout.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                boolean bVal = data[i];
                dout.writeBoolean(bVal);
            }
        }
    }

    public static boolean[] readBooleanArray(DataInput din) throws IOException {
        boolean[] value = null;
        byte isNull = din.readByte();
        if (isNull != 0) {
            int _length = din.readInt();
            value = new boolean[_length];
            for (int i = 0; i < _length; ++i) {
                value[i] = din.readBoolean();
            }
        }
        return value;
    }

    public static void writeByteArray(DataOutput dout, byte[] data) throws IOException {
        if (data == null) {
            dout.writeByte(0);
        } else {
            dout.writeByte(1);
            dout.writeInt(data.length);
            if (data.length != 0) {
                dout.write(data);
            }
        }
    }

    public static byte[] readByteArray(DataInput din) throws IOException {
        byte[] value = null;
        byte isNull = din.readByte();
        if (isNull != 0) {
            int _length = din.readInt();
            value = new byte[_length];
            din.readFully(value);
        }
        return value;
    }

    public static void writeCharArray(DataOutput dout, char[] data) throws IOException {
        if (data == null) {
            dout.writeByte(0);
        } else {
            dout.writeByte(1);
            dout.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                char cVal = data[i];
                dout.writeChar(cVal);
            }
        }
    }

    public static char[] readCharArray(DataInput din) throws IOException {
        char[] value = null;
        byte isNull = din.readByte();
        if (isNull != 0) {
            int _length = din.readInt();
            value = new char[_length];
            for (int i = 0; i < _length; ++i) {
                value[i] = din.readChar();
            }
        }
        return value;
    }

    public static void writeShortArray(DataOutput dout, short[] data) throws IOException {
        if (data == null) {
            dout.writeByte(0);
        } else {
            dout.writeByte(1);
            dout.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                short sVal = data[i];
                dout.writeShort(sVal);
            }
        }
    }

    public static short[] readShortArray(DataInput din) throws IOException {
        short[] value = null;
        byte isNull = din.readByte();
        if (isNull != 0) {
            int _length = din.readInt();
            value = new short[_length];
            for (int i = 0; i < _length; ++i) {
                value[i] = din.readShort();
            }
        }
        return value;
    }

    public static void writeLongArray(DataOutput dout, long[] data) throws IOException {
        if (data == null) {
            dout.writeByte(0);
        } else {
            dout.writeByte(1);
            dout.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                long lVal = data[i];
                dout.writeLong(lVal);
            }
        }
    }

    public static long[] readLongArray(DataInput din) throws IOException {
        long[] value = null;
        byte isNull = din.readByte();
        if (isNull != 0) {
            int _length = din.readInt();
            value = new long[_length];
            for (int i = 0; i < _length; ++i) {
                value[i] = din.readLong();
            }
        }
        return value;
    }

    public static void writeFloatArray(DataOutput dout, float[] data) throws IOException {
        if (data == null) {
            dout.writeByte(0);
        } else {
            dout.writeByte(1);
            dout.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                float fVal = data[i];
                dout.writeFloat(fVal);
            }
        }
    }

    public static float[] readFloatArray(DataInput din) throws IOException {
        float[] value = null;
        byte isNull = din.readByte();
        if (isNull != 0) {
            int _length = din.readInt();
            value = new float[_length];
            for (int i = 0; i < _length; ++i) {
                value[i] = din.readFloat();
            }
        }
        return value;
    }

    public static void writeDoubleArray(DataOutput dout, double[] data) throws IOException {
        if (data == null) {
            dout.writeByte(0);
        } else {
            dout.writeByte(1);
            dout.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                double dVal = data[i];
                dout.writeDouble(dVal);
            }
        }
    }

    public static double[] readDoubleArray(DataInput din) throws IOException {
        double[] value = null;
        byte isNull = din.readByte();
        if (isNull != 0) {
            int _length = din.readInt();
            value = new double[_length];
            for (int i = 0; i < _length; ++i) {
                value[i] = din.readDouble();
            }
        }
        return value;
    }

    public static void writeUTF(DataOutput dout, String data) throws IOException {
        if (data == null) {
            dout.writeByte(0);
        } else {
            dout.writeByte(1);
            dout.writeUTF(data);
        }
    }

    public static String readUTF(DataInput din) throws IOException {
        byte isNull = din.readByte();
        if (isNull == 0) {
            return null;
        }
        return din.readUTF();
    }
}

