/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.spec.server;

import java.io.InvalidObjectException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.util.Map;
import java.util.WeakHashMap;
import jeus.ejb.bean.objectbase.JEUSClusterStub;
import jeus.ejb.bean.rmi.StubClusterSupport;
import jeus.rmi.impl.server.JeusProxyMarker;
import jeus.rmi.impl.server.MethodInfo;
import jeus.rmi.impl.server.Util;
import jeus.rmi.impl.server.WeakClassHashMap;
import jeus.rmi.spec.ClientInterceptor;
import jeus.rmi.spec.server.RemoteObject;
import jeus.rmi.spec.server.RemoteRef;

public class RemoteObjectInvocationHandler
extends RemoteObject
implements InvocationHandler {
    private static final long serialVersionUID = 2L;
    private static final MethodToHash_Maps methodToHash_Maps = new MethodToHash_Maps();
    protected StubClusterSupport clusterSupport = null;
    protected Remote associatedProxy = null;
    private ClientInterceptor stubClientInterceptor;

    public RemoteObjectInvocationHandler(RemoteRef ref) {
        super(ref);
        if (ref == null) {
            throw new NullPointerException();
        }
    }

    public void setAssociatedProxy(int clusterType, Remote proxy) {
        this.associatedProxy = proxy;
        this.clusterSupport = StubClusterSupport.createStubClusterSupport(clusterType, this.associatedProxy);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        return this.invokeRemoteMethod(proxy, method, args);
    }

    private Object invokeObjectMethod(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if (name.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (name.equals("equals")) {
            Object obj = args[0];
            boolean b = proxy == obj || obj != null && Proxy.isProxyClass(obj.getClass()) && this.equals(Proxy.getInvocationHandler(obj));
            return b;
        }
        if (name.equals("toString")) {
            return this.proxyToString(proxy);
        }
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteMethod(Object proxy, Method method, Object[] args) throws Exception {
        try {
            if (!(proxy instanceof Remote)) {
                throw new IllegalArgumentException("proxy not Remote instance");
            }
            if (this.clusterSupport == null) {
                byte _returnTypeNum = MethodInfo.getReturnTypeNumber(method);
                return this.ref.invoke((Remote)proxy, method, args, RemoteObjectInvocationHandler.getMethodHash(method), MethodInfo.isSimpleParams(method), _returnTypeNum, MethodInfo.isVoidReturn(_returnTypeNum), -1);
            }
            while (true) {
                Proxy currProxy;
                String currExportName;
                StubClusterSupport stubClusterSupport = this.clusterSupport;
                synchronized (stubClusterSupport) {
                    currExportName = this.clusterSupport.getExportName();
                    currProxy = (Proxy)this.clusterSupport.getStub();
                }
                RemoteRef ref = ((RemoteObjectInvocationHandler)Proxy.getInvocationHandler(currProxy)).getRef();
                try {
                    byte _returnTypeNum = MethodInfo.getReturnTypeNumber(method);
                    Object result = ref.invoke((Remote)((Object)currProxy), method, args, RemoteObjectInvocationHandler.getMethodHash(method), MethodInfo.isSimpleParams(method), _returnTypeNum, MethodInfo.isVoidReturn(_returnTypeNum), -1);
                    if (result instanceof JEUSClusterStub) {
                        ((JEUSClusterStub)result).__jeus_setCluster(this.clusterSupport.getExportName(), this.clusterSupport.getCluster());
                    } else if (result instanceof JeusProxyMarker) {
                        ((RemoteObjectInvocationHandler)Proxy.getInvocationHandler((Object)result)).clusterSupport.__jeus_setCluster(this.clusterSupport.getExportName(), this.clusterSupport.getCluster());
                    }
                    return result;
                }
                catch (RemoteException ex) {
                    this.clusterSupport.handleException(ex, currExportName, false);
                    continue;
                }
                break;
            }
        }
        catch (Exception e2) {
            UnexpectedException e2;
            if (!(e2 instanceof RuntimeException)) {
                Class<?> cl = proxy.getClass();
                try {
                    method = cl.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException nsme) {
                    throw (IllegalArgumentException)new IllegalArgumentException().initCause(nsme);
                }
                Class<?>[] exTypes = method.getExceptionTypes();
                Class<?> thrownType = e2.getClass();
                for (int i = 0; i < exTypes.length; ++i) {
                    if (!exTypes[i].isAssignableFrom(thrownType)) continue;
                    throw e2;
                }
                e2 = new UnexpectedException("unexpected exception", e2);
            }
            throw e2;
        }
    }

    private String proxyToString(Object proxy) {
        int dot;
        Class<?>[] interfaces = proxy.getClass().getInterfaces();
        if (interfaces.length == 0) {
            return "Proxy[" + this + "]";
        }
        String iface = interfaces[0].getName();
        if (iface.equals("java.rmi.Remote") && interfaces.length > 1) {
            iface = interfaces[1].getName();
        }
        if ((dot = iface.lastIndexOf(46)) >= 0) {
            iface = iface.substring(dot + 1);
        }
        return "Proxy[" + iface + "," + this + "]";
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data in stream; class: " + this.getClass().getName());
    }

    private static long getMethodHash(Method method) {
        Map map = methodToHash_Maps.getMap(method.getDeclaringClass());
        Long hash = (Long)map.get(method);
        return hash;
    }

    public StubClusterSupport getClusterSupport() {
        return this.clusterSupport;
    }

    public void setClientInterceptor(ClientInterceptor stubClientInterceptor) {
        this.stubClientInterceptor = stubClientInterceptor;
    }

    public ClientInterceptor getClientInterceptor() {
        return this.stubClientInterceptor;
    }

    private static class MethodToHash_Maps
    extends WeakClassHashMap {
        MethodToHash_Maps() {
        }

        protected Map createMap(Class remoteClass) {
            return new WeakHashMap(){

                public synchronized Object get(Object key) {
                    Object hash = super.get(key);
                    if (hash == null) {
                        Method method = (Method)key;
                        hash = new Long(Util.computeMethodHash(method));
                        this.put(method, hash);
                    }
                    return (Long)hash;
                }
            };
        }
    }
}

