/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.spec.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.ServerCloneException;
import jeus.rmi.impl.server.UnicastServerRef;
import jeus.rmi.impl.server.UnicastServerRef2;
import jeus.rmi.impl.transport.ObjectTable;
import jeus.rmi.impl.transport.net.help.DefaultSocketChannelRMIClientSocketFactory;
import jeus.rmi.impl.transport.net.help.DefaultSocketChannelRMIServerSocketFactory;
import jeus.rmi.impl.transport.net.help.RMIPropertiesConstant;
import jeus.rmi.spec.server.RemoteServer;
import jeus.rmi.spec.server.RemoteStub;

public class UnicastRemoteObject
extends RemoteServer {
    private int port = 0;
    private RMIClientSocketFactory csf = null;
    private RMIServerSocketFactory ssf = null;
    private static final long serialVersionUID = 7729584040282154793L;
    private static DefaultSocketChannelRMIServerSocketFactory server = null;
    private static DefaultSocketChannelRMIClientSocketFactory client = null;

    protected UnicastRemoteObject() throws RemoteException {
        this(0);
    }

    protected UnicastRemoteObject(int port) throws RemoteException {
        this.port = port;
        UnicastRemoteObject.exportObject(this, port);
    }

    protected UnicastRemoteObject(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
        UnicastRemoteObject.exportObject(this, port, csf, ssf);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.reexport();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            UnicastRemoteObject cloned = (UnicastRemoteObject)super.clone();
            cloned.reexport();
            return cloned;
        }
        catch (RemoteException e) {
            throw new ServerCloneException("Clone failed", e);
        }
    }

    private void reexport() throws RemoteException {
        if (this.csf == null && this.ssf == null) {
            UnicastRemoteObject.exportObject(this, this.port);
        } else {
            UnicastRemoteObject.exportObject(this, this.port, this.csf, this.ssf);
        }
    }

    public static RemoteStub exportObject(Remote obj) throws RemoteException {
        return (RemoteStub)UnicastRemoteObject.exportObject(obj, 0);
    }

    public static Remote exportObject(Remote obj, int port) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, port, -1);
    }

    public static Remote exportObject(Remote obj, int port, int clusterType) throws RemoteException {
        if (RMIPropertiesConstant.useChannel) {
            return UnicastRemoteObject.exportObject(obj, port, client, server, clusterType);
        }
        UnicastServerRef serverRef = new UnicastServerRef(port);
        return serverRef.exportObject(obj, null, clusterType);
    }

    public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, int clusterType) throws RemoteException {
        UnicastServerRef2 serverRef = new UnicastServerRef2(port, csf, ssf);
        return serverRef.exportObject(obj, null, clusterType);
    }

    public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, port, csf, ssf, -1);
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        return ObjectTable.unexportObject(obj, force);
    }

    static {
        if (RMIPropertiesConstant.useChannel) {
            try {
                Class<?> serverFac = Class.forName("jeus.rmi.impl.transport.net.help.DefaultSocketChannelRMIServerSocketFactory");
                Class<?> clientFac = Class.forName("jeus.rmi.impl.transport.net.help.DefaultSocketChannelRMIClientSocketFactory");
                server = (DefaultSocketChannelRMIServerSocketFactory)serverFac.newInstance();
                client = (DefaultSocketChannelRMIClientSocketFactory)clientFac.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

