/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class AddSubjectCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public AddSubjectCommand() {
        super("addsubject", "Add a new Subject with given user name");
        this.addArgument(new Argument("username", "Subject username", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String username = (String)args.get("username");
        try {
            AuthenticationRepositoryService.getSubject(username);
            throw new Exception("Subject " + args.get("username") + " already exists");
        }
        catch (ServiceException e) {
            Subject sub = Subject.makeSubject(username);
            AuthenticationRepositoryService.addSubject(sub);
            return "Added Subject " + username;
        }
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = null;
        try {
            subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
            subjectMoMBean.getSubject(username);
            throw new Exception("Subject " + username + " already exists");
        }
        catch (ServiceException e) {
            if (subjectMoMBean == null) {
                throw new Exception("Domain( " + domainname + ") is not exist");
            }
            Subject sub = Subject.makeSubject(domainname, username, null, false);
            subjectMoMBean.addSubject(sub);
            out.println("Added Subject " + username);
            return;
        }
    }
}

