/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.security.Permission;
import java.util.Map;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Policy;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class AssignRoleCommand
extends Command {
    jeus.util.console.Argument principal_name;
    jeus.util.console.Argument role_name;
    ArgumentedOption action_list;
    ArgumentedOption context_id;
    ArgumentedOption class_name;
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public AssignRoleCommand() {
        super("assignrole", "Assign a role to a Principal (principal-to-role mapping)");
        this.principal_name = new Argument("principal", "The name of a Principal to be mapped to the role", String.class, false);
        this.role_name = new Argument("role", "The name of the role", String.class, false);
        this.action_list = new ArgumentedOption("actions", "actions", "The actions of the RolePermission", "action is null", true);
        this.context_id = new ArgumentedOption("contextid", "contextid", "Policy context id for mapping", "default contextid is \"default\"", true);
        this.class_name = new ArgumentedOption("classname", "classname", "The classname of the Permission", "default domain name is SYSTEM_DOMAIN", true);
        this.registerArgument(this.principal_name);
        this.registerArgument(this.role_name);
        this.registerArgument((jeus.util.console.Argument)this.action_list);
        this.registerArgument((jeus.util.console.Argument)this.context_id);
        this.registerArgument((jeus.util.console.Argument)this.class_name);
        this.registerArgument((jeus.util.console.Argument)this.domain);
        this.addArgument(new Argument("principal", "The name of a Principal to be mapped to the role ", String.class, false));
        this.addArgument(new Argument("role", "The name of the role", String.class, false));
        this.addArgument(new Argument("actions", "The actions of the resource", String.class, true));
        this.addArgument(new Argument("contextid", "Policy context id for mapping", String.class, true));
        this.addArgument(new Argument("classname", "The classname of the Permission", String.class, true));
    }

    public Object run(Map args) throws Exception {
        String classname;
        String role = (String)args.get("role");
        String principal = (String)args.get("principal");
        String actions = (String)args.get("actions");
        String contextid = (String)args.get("contextid");
        if (contextid == null) {
            contextid = "default";
        }
        if ((classname = (String)args.get("classname")) == null) {
            classname = Constants.DEFAULT_PR_PERMISSION_CLASSNAME;
        }
        Permission p = PermissionMaker.makePermission((String)classname, (String)role, (String)actions);
        Policy policy = new Policy();
        policy.getRolePolicy().addPermission(p, new Object[]{new PrincipalImpl(principal)}, false, false);
        policy.getResourcePolicy(contextid, true);
        AuthorizationRepositoryService.addPolicy(policy);
        return "Assigned role \"" + role + "\" to Principal \"" + principal + "\"";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String classname;
        String role = this.role_name.getValue();
        String principal = this.principal_name.getValue();
        String actions = this.action_list.getValue();
        String contextid = this.context_id.getValue();
        if (contextid == null) {
            contextid = "default";
        }
        if ((classname = this.class_name.getValue()) == null) {
            classname = Constants.DEFAULT_PR_PERMISSION_CLASSNAME;
        }
        Permission p = PermissionMaker.makePermission((String)classname, (String)role, (String)actions);
        Policy policy = new Policy();
        policy.getRolePolicy().addPermission(p, new Object[]{new PrincipalImpl(principal)}, false, false);
        policy.getResourcePolicy(contextid, true);
        String domainname = this.domain.getValue();
        PolicyMoMBean policyMoMBean = SecurityGroup.getPolicyMoMBean(domainname);
        if (policyMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        policyMoMBean.addPolicy(policy);
        out.println("Assigned role \"" + role + "\" to Principal \"" + principal + "\"");
    }
}

