/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.security.Permission;
import java.util.Map;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.spi.LoginService;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class AuthorizeResourceCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public AuthorizeResourceCommand() {
        super("authorizeresource", "Check whether the current Subject has permission to access the specified resource");
        this.addArgument(new Argument("resource", "Name of target resource", String.class, false));
        this.addArgument(new Argument("action", "Resource action to be performed", String.class, true));
        this.addArgument(new Argument("contextid", "Policy context id (scope)", String.class, true));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String resource = (String)args.get("resource");
        String action = (String)args.get("action");
        String contextid = (String)args.get("contextid");
        if (contextid == null) {
            contextid = "default";
        }
        String classname = Constants.DEFAULT_RR_PERMISSION_CLASSNAME;
        Permission p = PermissionMaker.makePermission((String)classname, (String)resource, (String)action);
        LoginService.checkPermission(contextid, p);
        return "Resource granted for current Subject";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String domainname;
        PolicyMoMBean policyMoMBean;
        String resource = this.getArgument("resource").getValue();
        String action = this.getArgument("action").getValue();
        String contextid = this.getArgument("contextid").getValue();
        if (contextid == null) {
            contextid = "default";
        }
        if ((policyMoMBean = SecurityGroup.getPolicyMoMBean(domainname = this.domain.getValue())) == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        policyMoMBean.authorizeResource(resource, action, contextid);
        out.println("Resource granted for current Subject");
    }
}

