/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.security.Permission;
import java.util.Map;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.spi.LoginService;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class AuthorizeRoleCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public AuthorizeRoleCommand() {
        super("authorizerole", "Check whether the current Subject has permission to access the specified role");
        this.addArgument(new Argument("role", "Name of target role", String.class, false));
        this.addArgument(new Argument("contextid", "Policy context id (scope)", String.class, true));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String role = (String)args.get("role");
        String contextid = (String)args.get("contextid");
        if (contextid == null) {
            contextid = "default";
        }
        String classname = Constants.DEFAULT_PR_PERMISSION_CLASSNAME;
        Permission p = PermissionMaker.makePermission((String)classname, (String)role, null);
        LoginService.checkPermission(contextid, p);
        return "Role granted for current Subject";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String domainname;
        PolicyMoMBean policyMoMBean;
        String role = this.getArgument("role").getValue();
        String contextid = this.getArgument("contextid").getValue();
        if (contextid == null) {
            contextid = "default";
        }
        if ((policyMoMBean = SecurityGroup.getPolicyMoMBean(domainname = this.domain.getValue())) == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        policyMoMBean.authorizeRole(contextid, role);
        out.println("Role granted for current Subject");
    }
}

