/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Command;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.util.Constants;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class GetGroupListCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public GetGroupListCommand() {
        super("getgroups", "Get information for all Group in the current security domain");
        this.registerArgument((Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        GroupPrincipalImpl[] groups = (GroupPrincipalImpl[])AuthenticationRepositoryService.getGroupList();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < groups.length; ++i) {
            GroupPrincipalImpl groupImpl = groups[i];
            result.append(groupImpl.toString());
            result.append(Constants.NEWLINE);
        }
        result.append("Got " + groups.length + " Group information");
        return result.toString();
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        GroupPrincipalImpl[] groups = (GroupPrincipalImpl[])subjectMoMBean.getGroupList();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < groups.length; ++i) {
            GroupPrincipalImpl groupImpl = groups[i];
            result.append(groupImpl.toString());
            result.append(Constants.NEWLINE);
        }
        result.append("Got " + groups.length + " Group information");
        out.println(result.toString());
    }
}

