/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Command;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.util.Constants;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class GetGroupNamesCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public GetGroupNamesCommand() {
        super("getgroupnames", "Get the names for all Group in the current security domain");
        this.registerArgument((Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        Set names = AuthenticationRepositoryService.getGroupNames();
        if (names != null) {
            StringBuffer result = new StringBuffer();
            Iterator iterator = names.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                result.append(i + ". ");
                result.append(iterator.next());
                result.append(Constants.NEWLINE);
                ++i;
            }
            result.append("Got " + names.size() + " Group names");
            return result.toString();
        }
        return "Got 0 Group names";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        Set names = subjectMoMBean.getGroupNames();
        if (names != null) {
            StringBuffer result = new StringBuffer();
            Iterator iterator = names.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                result.append(i + ". ");
                result.append(iterator.next());
                result.append(Constants.NEWLINE);
                ++i;
            }
            result.append("Got " + names.size() + " Group names");
            out.println(result.toString());
        } else {
            out.println("Got 0 Group names");
        }
    }
}

