/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.security.Permission;
import java.util.Map;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Policy;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class IncludeResourceCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public IncludeResourceCommand() {
        super("includeresource", "Include a resource (undo effect of excluderesource)");
        this.addArgument(new Argument("resource", "The name of the resource", String.class, false));
        this.addArgument(new Argument("actions", "The actions of the resource", String.class, true));
        this.addArgument(new Argument("contextid", "Policy context id for mapping", String.class, true));
        this.addArgument(new Argument("classname", "The classname of the Permission", String.class, true));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String classname;
        String resource = (String)args.get("resource");
        String actions = (String)args.get("actions");
        String contextid = (String)args.get("contextid");
        if (contextid == null) {
            contextid = "default";
        }
        if ((classname = (String)args.get("classname")) == null) {
            classname = Constants.DEFAULT_RR_PERMISSION_CLASSNAME;
        }
        Permission p = PermissionMaker.makePermission((String)classname, (String)resource, (String)actions);
        Policy policy = new Policy();
        policy.getResourcePolicy(contextid, true).addPermission(p, null, true, false);
        AuthorizationRepositoryService.removePolicy(policy);
        return "Included resource \"" + resource + "\"";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String classname;
        String resource = this.getArgument("resource").getValue();
        String actions = this.getArgument("actions").getValue();
        String contextid = this.getArgument("contextid").getValue();
        if (contextid == null) {
            contextid = "default";
        }
        if ((classname = this.getArgument("classname").getValue()) == null) {
            classname = Constants.DEFAULT_RR_PERMISSION_CLASSNAME;
        }
        Permission p = PermissionMaker.makePermission((String)classname, (String)resource, (String)actions);
        Policy policy = new Policy();
        policy.getResourcePolicy(contextid, true).addPermission(p, null, true, false);
        String domainname = this.domain.getValue();
        PolicyMoMBean policyMoMBean = SecurityGroup.getPolicyMoMBean(domainname);
        if (policyMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        policyMoMBean.removePolicy(policy);
        out.println("Included resource \"" + resource + "\"");
    }
}

