/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class IsMemberCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public IsMemberCommand() {
        super("ismember", "Verify that the user is the member of this group");
        this.addArgument(new Argument("groupname", "Group name", String.class, false));
        this.addArgument(new Argument("username", "User name", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String username;
        String groupname = (String)args.get("groupname");
        if (AuthenticationRepositoryService.isMember(groupname, new PrincipalImpl(username = (String)args.get("username")))) {
            return "The User(" + username + ") is the member of Group(" + groupname + ")";
        }
        return "The User(" + username + ") isn't the member of Group(" + groupname + ")";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String groupname = this.getArgument("groupname").getValue();
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        if (subjectMoMBean.isMember(groupname, new PrincipalImpl(username))) {
            out.println("The User(" + username + ") is the member of Group(" + groupname + ")");
        } else {
            out.println("The User(" + username + ") isn't the member of Group(" + groupname + ")");
        }
    }
}

