/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.Subject;
import jeus.security.resource.LockFactory;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class LockSubjectCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public LockSubjectCommand() {
        super("locksubject", "Lock out the Subject with the given user name");
        this.addArgument(new Argument("username", "Subject username", String.class, false));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        AuthenticationRepositoryService.getSubject((String)args.get("username"));
        Subject sub = Subject.makeSubject((String)args.get("username"));
        sub.getCredentialFactories().add(new LockFactory());
        AuthenticationRepositoryService.addSubject(sub);
        return "Subject " + (String)args.get("username") + " has been locked out";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        subjectMoMBean.getSubject(username);
        Subject sub = Subject.makeSubject(username);
        sub.getCredentialFactories().add(new LockFactory());
        subjectMoMBean.addSubject(sub);
        out.println("Subject " + sub + " has been locked out");
    }
}

