/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.spi.LoginService;

public class LoginCodeSubjectCommand
extends Command {
    public LoginCodeSubjectCommand() {
        super("logincode", "Log in the code subject, which will disable all authorization (only works if the global system password is correctly set)");
        this.addArgument(new Argument("domain", "the security domain name", String.class, true));
    }

    public Object run(Map args) throws Exception {
        String domainName = (String)args.get("domain");
        if (domainName == null) {
            LoginService.loginCodeSubject();
        } else {
            LoginService.loginCodeSubject(domainName);
        }
        return "Code Subject for domain " + LoginService.getCurrentSubject().getDomainName() + " logged in";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String domainName = this.getArgument("domain").getValue();
        if (domainName == null) {
            LoginService.loginCodeSubject();
        } else {
            LoginService.loginCodeSubject(domainName);
        }
        out.println("Code Subject for domain " + LoginService.getCurrentSubject().getDomainName() + " logged in");
    }
}

