/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.AddCredentialCommand;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.CredentialFactory;
import jeus.security.base.Subject;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.group.SecurityGroup;

public class RemoveCredentialCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public RemoveCredentialCommand() {
        super("removecredential", "Remove a custom credential from a Subject");
        this.addArgument(new Argument("username", "The user name of the Subject for which to remove the credential", String.class, false));
        this.addArgument(new Argument("classname", "The Java class name for a CredentialFactory", String.class, false));
        this.addArgument(new Argument("properties", "A property string for the CF. Format: name=value;name2=value2", String.class, true));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String username = (String)args.get("username");
        String classname = (String)args.get("classname");
        String properties = (String)args.get("properties");
        Subject sub = Subject.makeSubject(username);
        CredentialFactory cf = (CredentialFactory)Class.forName(classname).newInstance();
        AddCredentialCommand.addProperties(cf, properties);
        sub.getCredentialFactories().add(cf);
        AuthenticationRepositoryService.removeSubject(sub);
        return "Removed credential with credential factory \"" + classname + "\" from Subject \"" + username + "\"";
    }

    public Class getReturnType() {
        return String.class;
    }

    public void run(PrintStream out) throws Throwable {
        String username = this.getArgument("username").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        String classname = this.getArgument("classname").getValue();
        String properties = this.getArgument("properties").getValue();
        Subject sub = Subject.makeSubject(username);
        CredentialFactory cf = (CredentialFactory)Class.forName(classname).newInstance();
        AddCredentialCommand.addProperties(cf, properties);
        sub.getCredentialFactories().add(cf);
        subjectMoMBean.removeSubject(sub);
        out.println("Removed credential with credential factory \"" + classname + "\" from Subject \"" + username + "\"");
    }
}

