/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.admin.command;

import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.security.admin.command.Argument;
import jeus.security.admin.command.Command;
import jeus.security.base.ServiceException;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Example;
import jeus.util.console.group.SecurityGroup;

public class SetGroupDescriptionCommand
extends Command {
    ArgumentedOption domain = new ArgumentedOption("domain", "domain", "Domain domainname", "default domain name is SYSTEM_DOMAIN", true);

    public SetGroupDescriptionCommand() {
        super("setgroupdescription", "Set the description for the Group with the given group name and description");
        this.addArgument(new Argument("groupname", "Group name", String.class, false));
        this.addArgument(new Argument("description", "Group Description", String[].class, false));
        this.registerExample(new Example("setgroupdescription cts_group \"cts user group\"", "set description for cts_group"));
        this.registerArgument((jeus.util.console.Argument)this.domain);
    }

    public Object run(Map args) throws Exception {
        String groupname = (String)args.get("groupname");
        String[] description = (String[])args.get("description");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < description.length; ++i) {
            buf.append(description[i]);
            buf.append(" ");
        }
        GroupPrincipalImpl group = null;
        try {
            group = (GroupPrincipalImpl)AuthenticationRepositoryService.getGroup(groupname);
            group.setDescription(buf.toString());
        }
        catch (ServiceException e) {
            group = new GroupPrincipalImpl(groupname, buf.toString());
        }
        try {
            AuthenticationRepositoryService.addGroup(group);
        }
        catch (ServiceException s) {
            s.printStackTrace();
            throw new Exception("fail to updated group(" + (String)args.get("groupname") + ")");
        }
        return "Set description for Group " + groupname;
    }

    public Class getReturnType() {
        return String.class;
    }

    public Class getType() {
        return String[].class;
    }

    public void run(PrintStream out) throws Throwable {
        String groupname = this.getArgument("groupname").getValue();
        String description = this.getArgument("description").getValue();
        String domainname = this.domain.getValue();
        SubjectMoMBean subjectMoMBean = SecurityGroup.getSubjectMoMBean(domainname);
        if (subjectMoMBean == null) {
            throw new Exception("Domain( " + domainname + ") is not exist");
        }
        GroupPrincipalImpl group = null;
        try {
            group = (GroupPrincipalImpl)subjectMoMBean.getGroup(groupname);
            group.setDescription(description);
        }
        catch (ServiceException e) {
            group = new GroupPrincipalImpl(groupname, description);
        }
        try {
            subjectMoMBean.addGroup(group);
        }
        catch (ServiceException s) {
            s.printStackTrace();
            throw new Exception("fail to updated group(" + groupname + ")");
        }
        out.println("Set description for Group " + groupname);
    }
}

