/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import jeus.security.base.Domain;
import jeus.security.base.Environment;
import jeus.security.base.ServiceException;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.Constants;

public class Event
extends Hashtable
implements Map {
    private static final String NEWLINE = Constants.NEWLINE;
    public static final Level FATAL = new Level(Integer.MIN_VALUE, "fatal");
    public static final Level SERIOUS = new Level(-1073741824, "serious");
    public static final Level WARNING = new Level(0, "warning");
    public static final Level INFORMATION = new Level(0x3FFFFFFF, "information");
    public static final Level DEBUG = new Level(Integer.MAX_VALUE, "debug");
    public static final EventTimeComparator EVENT_TIME_COMPARATOR = new EventTimeComparator();
    private static int idCounter = 0;
    private long timeStamp = 0L;
    private String message = "";
    private Level level = DEBUG;
    private String type = "";
    private Throwable throwable;
    private String source;
    private String domain = "";
    private String id;
    private Environment config = null;

    public Event(String message, String type, Level level, Throwable throwable, String source) {
        this.type = type;
        this.timeStamp = System.currentTimeMillis();
        this.id = "" + idCounter++;
        this.config = SecurityInstaller.getEnvironment();
        this.level = level;
        this.type = type;
        this.message = message;
        this.source = source;
        this.throwable = throwable;
        try {
            this.domain = Domain.getCurrentDomain().getName();
        }
        catch (ServiceException e) {
            this.domain = "(domain not set)";
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof Event) {
            Event e = (Event)other;
            return this.getId().equals(e.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Environment getEnvironment() {
        return this.config;
    }

    public String getMessage() {
        return this.message;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getType() {
        return this.type;
    }

    public Throwable getTrowable() {
        return this.throwable;
    }

    public String getSource() {
        return this.source;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getId() {
        return this.id;
    }

    public String getDomain() {
        return this.domain;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("_______________________EVENT________________________");
        buf.append(NEWLINE + "ID: ");
        buf.append(this.getId());
        buf.append(NEWLINE + "DOMAIN: ");
        buf.append(this.getDomain());
        buf.append(NEWLINE + "TIME: ");
        buf.append(new Date(this.getTimeStamp()));
        buf.append(NEWLINE + "MESSAGE: ");
        buf.append(this.getMessage());
        buf.append(NEWLINE + "TYPE: ");
        buf.append(this.getType());
        buf.append(NEWLINE + "LEVEL: ");
        buf.append(this.getLevel().getName());
        buf.append(NEWLINE + "SOURCE: ");
        buf.append(this.getSource());
        if (this.getTrowable() != null) {
            buf.append(NEWLINE + "THROWABLE: ");
            buf.append(this.getTrowable());
        }
        Enumeration en = this.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object o = this.get(key);
            buf.append(NEWLINE + "CONTEXT " + key + ": ");
            buf.append(o.toString());
        }
        buf.append(NEWLINE);
        buf.append("____________________________________________________");
        buf.append(NEWLINE);
        return buf.toString();
    }

    private static class EventTimeComparator
    implements Comparator {
        private EventTimeComparator() {
        }

        public int compare(Object o1, Object o2) {
            Event e1 = (Event)o1;
            Event e2 = (Event)o2;
            long result = e1.getTimeStamp() - e2.getTimeStamp();
            if (result == 0L) {
                return 0;
            }
            if (result < 0L) {
                return -1;
            }
            return 1;
        }
    }

    public static class Level
    implements Serializable {
        static final long serialVersionUID = -4097065647387709042L;
        private String name = "";
        private int level = 0;

        public Level(String name) {
            this.name = name;
            if (name != null) {
                this.level = name.equalsIgnoreCase(FATAL.getName()) ? Event.FATAL.level : (name.equalsIgnoreCase(SERIOUS.getName()) ? Event.SERIOUS.level : (name.equalsIgnoreCase(WARNING.getName()) ? Event.WARNING.level : (name.equalsIgnoreCase(INFORMATION.getName()) ? Event.INFORMATION.level : (name.equalsIgnoreCase(DEBUG.getName()) ? Event.DEBUG.level : Integer.MAX_VALUE))));
            }
        }

        public Level(int level, String name) {
            this.level = level;
            this.name = name;
        }

        public int getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && other instanceof Level) {
                Level l = (Level)other;
                return this.level == l.level;
            }
            return false;
        }

        public int hashCode() {
            return this.level;
        }

        public boolean hasHigherPriorityThan(Level l) {
            return this.level < l.level;
        }

        public boolean hasSamePriorityAs(Level l) {
            return this.level == l.level;
        }

        public boolean hasHigherOrSamePriorityAs(Level l) {
            return this.hasHigherPriorityThan(l) || this.hasSamePriorityAs(l);
        }
    }
}

