/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.security.Permission;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.Role;
import jeus.security.impl.aznrep.CustomJeusDBPoliciesConverter;
import jeus.security.resource.RolePermission;
import jeus.security.util.CopyOnWriteHashSet;

public class JeusDBPolicyImpl
extends Policy {
    private CustomJeusDBPoliciesConverter conv;

    public CustomJeusDBPoliciesConverter getConv() {
        return this.conv;
    }

    public void setConv(CustomJeusDBPoliciesConverter conv) {
        this.conv = conv;
    }

    public PermissionMap getRolePolicy() {
        try {
            return this.conv.getRolePolicy();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PermissionMap getResourcePolicy(String contextId, boolean create) {
        PermissionMap pm = (PermissionMap)this.roleResourcePolicy.get(contextId);
        if (pm == null && create) {
            pm = new PermissionMap(true);
            this.roleResourcePolicy.put(contextId, pm);
        }
        return pm;
    }

    public PermissionMap getResourcePolicy(String contextId) {
        return this.getResourcePolicy(contextId, false);
    }

    public void removeResourcePolicy(String contextId) {
        this.roleResourcePolicy.remove(contextId);
    }

    public Set getResourcePolicyIds() {
        return this.roleResourcePolicy.keySet();
    }

    public JeusDBPolicyImpl add(JeusDBPolicyImpl otherPolicy) {
        if (otherPolicy != null && otherPolicy != this) {
            this.getRolePolicy().add(otherPolicy.getRolePolicy());
            for (String id : otherPolicy.getResourcePolicyIds()) {
                this.getResourcePolicy(id, true).add(otherPolicy.getResourcePolicy(id));
            }
        }
        return this;
    }

    public JeusDBPolicyImpl remove(JeusDBPolicyImpl otherPolicy) {
        if (otherPolicy == null) {
            return this;
        }
        if (otherPolicy == this) {
            this.getRolePolicy().clear();
            this.roleResourcePolicy.clear();
        } else {
            this.getRolePolicy().remove(otherPolicy.getRolePolicy());
            for (String id : otherPolicy.getResourcePolicyIds()) {
                PermissionMap pm = this.getResourcePolicy(id);
                if (pm == null) continue;
                pm.remove(otherPolicy.getResourcePolicy(id));
            }
        }
        return this;
    }

    public PermissionMap.CheckResult checkPermission(String contextId, Permission permission) {
        return this.checkPermission(contextId, (Principal)null, permission);
    }

    public PermissionMap.CheckResult checkPermission(Permission permission) {
        return this.checkPermission("default", (Principal)null, permission);
    }

    public PermissionMap.CheckResult checkPermission(Principal principal, Permission permission) {
        return this.checkPermission("default", principal, permission);
    }

    public PermissionMap.CheckResult checkPermission(String contextId, Principal principal, Permission permission) {
        if (permission instanceof RolePermission) {
            PermissionMap.CheckResult result = this.principalRolePolicy.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            result = this.principalRolePolicy.checkPermission(principal, permission);
            if (result.isGranted()) {
                return PermissionMap.GRANTED;
            }
        } else {
            PermissionMap map = this.getResourcePolicy(contextId);
            if (map == null) {
                return PermissionMap.DENIED;
            }
            PermissionMap.CheckResult result = map.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            for (Role role : map.getCheckedReversePermissionImplies(permission)) {
                RolePermission rolePermission = new RolePermission(role);
                result = this.principalRolePolicy.checkPermission(rolePermission);
                if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                    return result;
                }
                result = this.principalRolePolicy.checkPermission(principal, rolePermission);
                if (!result.isGranted()) continue;
                return PermissionMap.GRANTED;
            }
        }
        return PermissionMap.DENIED;
    }

    public PermissionMap.CheckResult checkPermission(String contextId, Principal[] principals, Permission permission) {
        if (permission instanceof RolePermission) {
            PermissionMap.CheckResult result = this.principalRolePolicy.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            for (int i = 0; i < principals.length; ++i) {
                Principal p = principals[i];
                result = this.principalRolePolicy.checkPermission(p, permission);
                if (!result.isGranted()) continue;
                return PermissionMap.GRANTED;
            }
        } else {
            PermissionMap map = this.getResourcePolicy(contextId);
            if (map == null) {
                return PermissionMap.DENIED;
            }
            PermissionMap.CheckResult result = map.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            for (Role role : map.getCheckedReversePermissionImplies(permission)) {
                RolePermission rolePermission = new RolePermission(role);
                result = this.principalRolePolicy.checkPermission(rolePermission);
                if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                    return result;
                }
                for (int i = 0; i < principals.length; ++i) {
                    Principal p = principals[i];
                    result = this.principalRolePolicy.checkPermission(p, rolePermission);
                    if (!result.isGranted()) continue;
                    return PermissionMap.GRANTED;
                }
            }
        }
        return PermissionMap.DENIED;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\n______________POLICY_______________\n\n");
        strBuf.append("ROLE PERMISSIONS:\n" + this.principalRolePolicy + "\n");
        strBuf.append("RESOURCE PERMISSIONS:\n");
        for (String id : this.getResourcePolicyIds()) {
            PermissionMap pm = this.getResourcePolicy(id);
            strBuf.append("Context id: " + id + "\n" + pm + "\n\n");
        }
        return strBuf.toString();
    }

    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (anotherObject == null) {
            return false;
        }
        if (anotherObject instanceof JeusDBPolicyImpl) {
            JeusDBPolicyImpl dpc = (JeusDBPolicyImpl)anotherObject;
            return this.getRolePolicy().equals(dpc.getRolePolicy()) && ((Object)this.roleResourcePolicy).equals(dpc.roleResourcePolicy);
        }
        return false;
    }

    public int hashCode() {
        return this.getRolePolicy().hashCode() + ((Object)this.roleResourcePolicy).hashCode();
    }

    public Object clone() {
        JeusDBPolicyImpl newDPC = new JeusDBPolicyImpl();
        newDPC.add(this);
        return newDPC;
    }

    public Collection getAllPermissions() {
        HashSet result = new HashSet();
        result.addAll(this.getRolePolicy().getAllPermissions());
        for (String id : this.getResourcePolicyIds()) {
            PermissionMap pm = this.getResourcePolicy(id);
            result.addAll(pm.getAllPermissions());
        }
        return new CopyOnWriteHashSet(result);
    }
}

