/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.io.Serializable;
import jeus.security.base.Subject;
import jeus.security.util.NameAndPathUtil;

public class NetworkMessage
implements Serializable {
    static final long serialVersionUID = -6656725435294676389L;
    private byte opcode;
    private Subject subject;
    private Serializable[] arguments;
    private long timeStamp = System.currentTimeMillis();
    private String host = NameAndPathUtil.getHostName();
    private boolean broadcasted;
    private int broadcastType;
    public static final NetworkMessage NULL_REPLY = new NetworkMessage(66, null, null);

    public String toString() {
        return "NetworkMessage[opcode : " + this.opcode + ", broadcasted :  " + this.broadcasted + ", broadcastType : " + this.broadcastType + ", subject : " + this.subject + ", serializable : " + this.arguments;
    }

    public NetworkMessage(byte opcode, Subject subject, Serializable[] arguments) {
        this.opcode = opcode;
        this.subject = subject;
        this.broadcasted = false;
        this.broadcastType = 0;
        this.arguments = arguments;
    }

    public NetworkMessage(byte opcode, Subject subject, int broadcastType, Serializable[] arguments) {
        this.opcode = opcode;
        this.subject = subject;
        this.broadcasted = false;
        this.broadcastType = broadcastType;
        this.arguments = arguments;
    }

    public NetworkMessage(byte opcode, Subject subject, boolean broadcasted, int broadcastType, Serializable[] arguments) {
        this.opcode = opcode;
        this.subject = subject;
        this.broadcasted = broadcasted;
        this.broadcastType = broadcastType;
        this.arguments = arguments;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Serializable[] getArguments() {
        return this.arguments;
    }

    public String getVMHost() {
        return this.host;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isBroadcasted() {
        return this.broadcasted;
    }

    public void setBroadcasted(boolean broadcasted) {
        this.broadcasted = broadcasted;
    }

    public int getBroadcastType() {
        return this.broadcastType;
    }

    public void setBroadcastType(int broadcastType) {
        this.broadcastType = broadcastType;
    }
}

