/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import jeus.security.base.Domain;
import jeus.security.base.Policy;
import jeus.security.base.ServiceException;
import jeus.security.util.Constants;

public class PolicyFactory {
    public static Policy getPolicyImplInDomain(String domainName) {
        String className;
        Domain domain = null;
        try {
            domain = domainName == null ? Domain.getCurrentDomain() : Domain.getDomain(domainName);
            className = domain == null ? Constants.DEFAULT_POLICY_IMPL_CLASSNAME : domain.getPolicyClassName();
        }
        catch (ServiceException e) {
            e.printStackTrace();
            className = null;
        }
        Policy policy = null;
        try {
            policy = (Policy)Class.forName(className).newInstance();
            if (domain != null) {
                policy.setUserPrincipalClassName(domain.getUserPrincipalClassName());
                policy.setRolePrincipalClassName(domain.getRolePrincipalClassName());
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return policy;
    }

    public static Policy getPolicyFactory(String className) {
        Policy policy = null;
        try {
            if (className == null) {
                className = Constants.DEFAULT_POLICY_IMPL_CLASSNAME;
            }
            policy = (Policy)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return policy;
    }
}

