/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.ear;

import java.io.File;
import java.security.Permission;
import java.security.Principal;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import jeus.security.base.Domain;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.container.shared.J2EESecurityUtil;
import jeus.security.impl.atnrep.XMLAccountConverter;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.RolePermissionType;

public class ApplicationSecurity {
    private static Map subjectsTableForRemove = new Hashtable();

    public static void addPolicy(Policy applicationPolicy, String domainName, ApplicationType appInfo) throws Exception {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        if (appInfo != null) {
            for (RolePermissionType rpt : appInfo.getRolePermission()) {
                Iterator principalNames = rpt.getPrincipal().iterator();
                HashSet<PrincipalImpl> principals = new HashSet<PrincipalImpl>();
                while (principalNames.hasNext()) {
                    String name = (String)((JAXBElement)principalNames.next()).getValue();
                    principals.add(new PrincipalImpl(name));
                }
                Object[] ps = principals.toArray(new Principal[0]);
                String classname = rpt.getClassname();
                if (classname == null) {
                    classname = Constants.DEFAULT_PR_PERMISSION_CLASSNAME;
                }
                Permission p = PermissionMaker.makePermission((String)classname, (String)rpt.getRole(), (String)rpt.getActions());
                boolean excluded = rpt.getExcluded() != null;
                boolean unchecked = rpt.getUnchecked() != null;
                applicationPolicy.getRolePolicy().addPermission(p, ps, excluded, unchecked);
            }
        }
        J2EESecurityUtil.addPolicy(applicationPolicy, domainName);
    }

    public static void addPolicy(Policy applicationPolicy, String domainName) throws Exception {
        ApplicationSecurity.addPolicy(applicationPolicy, domainName, null);
    }

    public static void removePolicy(String id, String domainName) throws Exception {
        J2EESecurityUtil.removePolicy(id, domainName);
    }

    public static void removePolicy(Policy policy, String domain) throws Exception {
        if (SecurityInstaller.isSecurityOff()) {
            return;
        }
        for (String id : policy.getResourcePolicyIds()) {
            J2EESecurityUtil.removePolicy(id, domain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSubjects(String domainName, String key, String path) throws ServiceException {
        Subject[] subjects;
        XMLAccountConverter conv;
        File theFile = new File(path + File.separator + "accounts.xml");
        if (!theFile.exists()) {
            return;
        }
        if (domainName == null) {
            domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        } else if (domainName.equals("SYSTEM_DOMAIN")) {
            return;
        }
        try {
            conv = new XMLAccountConverter(domainName);
        }
        catch (Exception e) {
            return;
        }
        try {
            subjects = (Subject[])conv.unmarshal(theFile);
        }
        catch (Exception e) {
            throw new ServiceException(e.toString());
        }
        try {
            LoginService.loginCodeSubject(domainName);
            AuthenticationRepositoryService.addSubjects(domainName, subjects, false);
        }
        catch (SecurityException se) {
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Exception e) {}
        }
        subjectsTableForRemove.put(domainName + ":" + key, subjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSubjects(String domainName, String key) throws ServiceException {
        if (domainName == null) {
            domainName = Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        } else if (domainName.equals("SYSTEM_DOMAIN")) {
            return;
        }
        Subject[] subjects = (Subject[])subjectsTableForRemove.remove(domainName + ":" + key);
        if (subjects == null) {
            return;
        }
        try {
            LoginService.loginCodeSubject(domainName);
            AuthenticationRepositoryService.removeSubjects(domainName, subjects, false);
        }
        catch (SecurityException se) {
        }
        finally {
            try {
                LoginService.logout();
            }
            catch (Exception e) {}
        }
    }
}

