/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.ejb;

import java.security.Permission;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import jeus.security.base.PermissionMap;
import jeus.security.resource.RoleImpl;
import jeus.security.util.JACCUtil;
import jeus.security.util.XMLConverter;
import jeus.util.JeusRuntimeException;
import jeus.xml.binding.j2ee.AssemblyDescriptorType;
import jeus.xml.binding.j2ee.EjbJarType;
import jeus.xml.binding.j2ee.EjbNameType;
import jeus.xml.binding.j2ee.EmptyType;
import jeus.xml.binding.j2ee.EntityBeanType;
import jeus.xml.binding.j2ee.JavaTypeType;
import jeus.xml.binding.j2ee.MethodIntfType;
import jeus.xml.binding.j2ee.MethodNameType;
import jeus.xml.binding.j2ee.MethodParamsType;
import jeus.xml.binding.j2ee.MethodPermissionType;
import jeus.xml.binding.j2ee.MethodType;
import jeus.xml.binding.j2ee.RoleNameType;
import jeus.xml.binding.j2ee.SecurityRoleRefType;
import jeus.xml.binding.j2ee.SessionBeanType;

public class XMLJ2EEEJBDDConverter
extends XMLConverter {
    public XMLJ2EEEJBDDConverter() throws Exception {
        super("jeus.xml.binding.j2ee");
    }

    protected Object fromXMLTree(Object contentTree) throws Exception {
        EjbJarType dd = (EjbJarType)contentTree;
        if (dd != null) {
            AssemblyDescriptorType modInfo = dd.getAssemblyDescriptor();
            PermissionMap pc = this.getMethodPermissionsPC(modInfo);
            PermissionMap pc2 = this.getRoleRefPermissionsPC(dd);
            return pc.add(pc2);
        }
        return new PermissionMap(true);
    }

    private PermissionMap getMethodPermissionsPC(AssemblyDescriptorType modInfo) throws Exception {
        PermissionMap pc = new PermissionMap(true);
        if (modInfo == null) {
            return pc;
        }
        for (MethodPermissionType mp : modInfo.getMethodPermission()) {
            List roles = mp.getRoleName();
            EmptyType unchecked = mp.getUnchecked();
            for (MethodType m : mp.getMethod()) {
                EJBMethodPermission perm = this.getEJBMethodPermission(m);
                Iterator rs = roles.iterator();
                Object[] rolesArray = new Object[roles.size()];
                boolean unchk = false;
                int i = 0;
                while (rs.hasNext()) {
                    RoleNameType rnt = (RoleNameType)rs.next();
                    rolesArray[i++] = new RoleImpl(rnt.getValue());
                }
                if (unchecked != null) {
                    unchk = true;
                }
                pc.addPermission((Permission)perm, rolesArray, false, unchk);
            }
        }
        if (modInfo.getExcludeList() != null) {
            for (MethodType m : modInfo.getExcludeList().getMethod()) {
                EJBMethodPermission perm = this.getEJBMethodPermission(m);
                pc.addPermission((Permission)perm, null, true, false);
            }
        }
        return pc;
    }

    private PermissionMap getRoleRefPermissionsPC(EjbJarType jar) {
        PermissionMap pc = new PermissionMap(true);
        if (jar == null || jar.getEnterpriseBeans() == null) {
            return pc;
        }
        for (Object o : jar.getEnterpriseBeans().getSessionOrEntityOrMessageDriven()) {
            String ejbName;
            Iterator securityRoleRefs;
            if (o instanceof SessionBeanType) {
                SessionBeanType sbt = (SessionBeanType)o;
                securityRoleRefs = sbt.getSecurityRoleRef().iterator();
                ejbName = sbt.getEjbName().getValue();
            } else {
                if (!(o instanceof EntityBeanType)) continue;
                EntityBeanType ebt = (EntityBeanType)o;
                securityRoleRefs = ebt.getSecurityRoleRef().iterator();
                ejbName = ebt.getEjbName().getValue();
            }
            while (securityRoleRefs.hasNext()) {
                SecurityRoleRefType srrt = (SecurityRoleRefType)securityRoleRefs.next();
                String roleName = srrt.getRoleName().getValue();
                RoleNameType roleLink = srrt.getRoleLink();
                if (roleLink == null) {
                    throw new JeusRuntimeException("The role-link is not specified for the role name " + roleName);
                }
                EJBRoleRefPermission perm = new EJBRoleRefPermission(ejbName, roleName);
                pc.updateCheckedPermission((Permission)perm, new RoleImpl(roleLink.getValue()));
            }
        }
        return pc;
    }

    private EJBMethodPermission getEJBMethodPermission(MethodType m) {
        EjbNameType ejbN = m.getEjbName();
        MethodIntfType methodI = m.getMethodIntf();
        MethodNameType methodN = m.getMethodName();
        MethodParamsType methodP = m.getMethodParams();
        String ejbName = ejbN.getValue();
        String methodIntf = null;
        if (methodI != null) {
            methodIntf = methodI.getValue();
        }
        String methodName = null;
        if (methodN != null) {
            methodName = methodN.getValue();
        }
        String[] methodParams = null;
        if (methodP != null) {
            Iterator iter = methodP.getMethodParam().iterator();
            Vector<String> v = new Vector<String>();
            while (iter.hasNext()) {
                JavaTypeType jtt = (JavaTypeType)iter.next();
                String mt = jtt.getValue();
                v.add(mt);
            }
            methodParams = v.toArray(new String[0]);
        }
        return new EJBMethodPermission(ejbName, XMLJ2EEEJBDDConverter.makeEJBMethodSpecString(methodName, methodIntf, methodParams));
    }

    public static String makeEJBMethodSpecString(String methodName, String methodIntf, String[] methodParams) {
        String result;
        StringBuffer strBuf = new StringBuffer("");
        if (methodName != null) {
            if (methodName.equals("*")) {
                methodName = "";
            }
            strBuf.append(methodName);
        }
        if (methodIntf != null) {
            strBuf.append(",");
            strBuf.append(methodIntf);
        } else if (JACCUtil.isRunningJACCCTS()) {
            methodIntf = "Remote";
            strBuf.append(",");
            strBuf.append(methodIntf);
        }
        if (methodParams != null) {
            if (methodIntf == null) {
                strBuf.append(",");
            }
            if (methodParams.length == 0) {
                strBuf.append(",");
            } else {
                for (int i = 0; i < methodParams.length; ++i) {
                    String p = methodParams[i];
                    strBuf.append(",");
                    strBuf.append(p);
                }
            }
        }
        return (result = strBuf.toString()).equals("") ? null : result;
    }

    protected Object toXMLTree(Object object, Object tree) {
        return null;
    }
}

