/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.shared;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import jeus.container.security.MethodSecurityInfo;
import jeus.container.security.SecurityAnnotationInfo;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.PolicyFactory;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.container.ejb.XMLJ2EEEJBDDConverter;
import jeus.security.container.ejb.XMLJEUSEJBDDConverter;
import jeus.security.container.shared.SecurityContext;
import jeus.security.resource.RoleImpl;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JACCUtil;
import jeus.security.util.XMLConverter;
import jeus.util.ArrayListStack;
import jeus.xml.binding.j2ee.EjbJarType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;

public final class J2EESecurityUtil {
    private static InheritableThreadLocal inst = new InheritableThreadLocal();
    private static InheritableThreadLocal met = new InheritableThreadLocal();
    private static InheritableThreadLocal arg = new InheritableThreadLocal();
    private static PrivilegedExceptionAction runner = new PrivilegedExceptionAction(){

        public Object run() throws Exception {
            Object instance = inst.get();
            Object method = met.get();
            Object arguments = arg.get();
            if (instance != null && method != null) {
                Method m = (Method)method;
                Object[] args = new Object[]{};
                if (arguments != null) {
                    args = (Object[])arguments;
                }
                return m.invoke(instance, args);
            }
            throw new Exception("Failed to invoke method in PrivilegedExceptionAction: instance and/or method object not specified");
        }
    };
    private static ThreadLocal contextStack = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new ArrayListStack();
        }
    };
    private static ThreadLocal currentSecurityContext = new ThreadLocal();

    public static void pushSecurityContext(SecurityContext sc) {
        ((ArrayListStack)contextStack.get()).push((Object)sc);
        if (JACCUtil.isJACCUsed()) {
            PolicyContext.setHandlerData((Object)sc);
        }
        currentSecurityContext.set(sc);
    }

    public static SecurityContext peekSecurityContext() {
        return (SecurityContext)currentSecurityContext.get();
    }

    public static SecurityContext peekRunasSecurityContext() {
        ArrayListStack ctx = (ArrayListStack)contextStack.get();
        if (!ctx.isEmpty()) {
            if (ctx.size() >= 2) {
                return (SecurityContext)ctx.get(ctx.size() - 2);
            }
            return (SecurityContext)currentSecurityContext.get();
        }
        return null;
    }

    public static SecurityContext popSecurityContext() {
        ArrayListStack ctx = (ArrayListStack)contextStack.get();
        if (ctx.isEmpty()) {
            if (JACCUtil.isJACCUsed()) {
                PolicyContext.setHandlerData(null);
            }
            currentSecurityContext.set(null);
            return null;
        }
        SecurityContext sc = (SecurityContext)ctx.pop();
        if (JACCUtil.isJACCUsed()) {
            SecurityContext sc2 = J2EESecurityUtil.peekSecurityContext();
            PolicyContext.setHandlerData((Object)sc2);
        }
        if (ctx.isEmpty()) {
            if (JACCUtil.isJACCUsed()) {
                PolicyContext.setHandlerData(null);
            }
            currentSecurityContext.set(null);
        } else {
            currentSecurityContext.set(ctx.peek());
        }
        return sc;
    }

    public static Object runCode(Object instance, Method m, Object[] args) throws Throwable {
        if (!JACCUtil.isJACCUsed()) {
            return m.invoke(instance, args);
        }
        try {
            inst.set(instance);
            met.set(m);
            arg.set(args);
            jeus.security.base.Subject s = LoginService.getCurrentSubject();
            return Subject.doAs(s == null ? null : s.toJAASSubject(), runner);
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof InvocationTargetException) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public static SecurityContext getSecurityContext() {
        return new SecurityContext();
    }

    public static Policy makePolicy(String policyId, Object j2eeJaxbTree, Object jeusJaxbTree, XMLConverter j2eeConv, XMLConverter jeusConv) throws Exception {
        PermissionMap pc1 = (PermissionMap)j2eeConv.unmarshal(j2eeJaxbTree);
        PermissionMap pc2 = (PermissionMap)jeusConv.unmarshal(jeusJaxbTree);
        Policy dpc = PolicyFactory.getPolicyImplInDomain(null);
        dpc.getRolePolicy().add(pc2);
        dpc.getResourcePolicy(policyId, true).add(pc1);
        return dpc;
    }

    public static Policy makePolicy(String policyId, Object j2eeJaxbTree, Object jeusJaxbTree, XMLConverter j2eeConv, XMLConverter jeusConv, String domainName) throws Exception {
        PermissionMap pc1 = (PermissionMap)j2eeConv.unmarshal(j2eeJaxbTree);
        PermissionMap pc2 = (PermissionMap)jeusConv.unmarshal(jeusJaxbTree);
        Policy dpc = PolicyFactory.getPolicyImplInDomain(domainName);
        dpc.getRolePolicy().add(pc2);
        dpc.getResourcePolicy(policyId, true).add(pc1);
        return dpc;
    }

    private static PermissionMap completePolicyContextForEJBAnnotation(List beanInfos) {
        PermissionMap pc = new PermissionMap(true);
        for (int i = 0; i < beanInfos.size(); ++i) {
            BeanInfo beanInfo = (BeanInfo)beanInfos.get(i);
            SecurityAnnotationInfo securityAnnotationInfo = beanInfo.getSecurityAnnotationInfo();
            if (securityAnnotationInfo == null) continue;
            String[] declareRoles = securityAnnotationInfo.getDeclaredRoles();
            List<MethodSecurityInfo> methodList = securityAnnotationInfo.getMethodList();
            for (int j = 0; j < methodList.size(); ++j) {
                MethodSecurityInfo methodSecurityInfo = methodList.get(j);
                if (methodSecurityInfo.isSecuritySpecified()) {
                    EJBMethodPermission perm;
                    Method method;
                    boolean excluded = methodSecurityInfo.isDenyAll();
                    boolean unchecked = methodSecurityInfo.isPermitAll();
                    String[] owner = methodSecurityInfo.getRolesAllowed();
                    Object[] roleImpls = null;
                    if (owner != null) {
                        roleImpls = new RoleImpl[owner.length];
                        for (int k = 0; k < owner.length; ++k) {
                            roleImpls[k] = new RoleImpl(owner[k]);
                        }
                    }
                    if ((method = methodSecurityInfo.getMethod()).getParameterTypes().length == 0 && JACCUtil.isRunningJACCCTS()) {
                        perm = new EJBMethodPermission(beanInfo.getBeanName(), method.getName() + "," + "Local");
                        pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                        perm = new EJBMethodPermission(beanInfo.getBeanName(), method.getName() + "," + "LocalHome");
                        pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                        perm = new EJBMethodPermission(beanInfo.getBeanName(), method.getName() + "," + "Remote");
                        pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                        perm = new EJBMethodPermission(beanInfo.getBeanName(), method.getName() + "," + "Home");
                        pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                        perm = new EJBMethodPermission(beanInfo.getBeanName(), method.getName() + "," + "ServiceEndpoint");
                        pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                        continue;
                    }
                    perm = new EJBMethodPermission(beanInfo.getBeanName(), "Local", method);
                    pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                    perm = new EJBMethodPermission(beanInfo.getBeanName(), "LocalHome", method);
                    pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                    perm = new EJBMethodPermission(beanInfo.getBeanName(), "Remote", method);
                    pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                    perm = new EJBMethodPermission(beanInfo.getBeanName(), "Home", method);
                    pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                    perm = new EJBMethodPermission(beanInfo.getBeanName(), "ServiceEndpoint", method);
                    pc.addPermission((Permission)perm, roleImpls, excluded, unchecked);
                    continue;
                }
                pc.addUnspecifiedMethodInfo(beanInfo.getBeanName(), methodSecurityInfo.getMethod());
            }
            for (String declareRole : declareRoles) {
                EJBRoleRefPermission perm = new EJBRoleRefPermission(beanInfo.getBeanName(), declareRole);
                pc.addPermission((Permission)perm, new Object[]{new RoleImpl(declareRole)}, false, false);
            }
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPolicy(Policy dpc, String domainName) throws ServiceException, SecurityException {
        if (domainName != null) {
            LoginService.loginCodeSubject(domainName);
        } else {
            LoginService.loginCodeSubject(SecurityInstaller.getEnvironment().defaultDomainName);
        }
        try {
            AuthorizationRepositoryService.addPolicy(dpc, true);
        }
        finally {
            LoginService.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePolicy(String contextId, String domainName) throws ServiceException, SecurityException {
        if (domainName != null) {
            LoginService.loginCodeSubject(domainName);
        } else {
            LoginService.loginCodeSubject(SecurityInstaller.getEnvironment().defaultDomainName);
        }
        try {
            AuthorizationRepositoryService.removePolicy(contextId, true);
        }
        finally {
            LoginService.logout();
        }
    }

    public static Policy makePolicy(ModuleInfo moduleInfo, String domainName) throws Exception {
        PermissionMap pc1 = null;
        Policy dpc = PolicyFactory.getPolicyImplInDomain(domainName);
        pc1 = J2EESecurityUtil.completePolicyContextForEJBAnnotation(moduleInfo.getBeanList());
        EjbJarType j2eeJaxbTree = moduleInfo.getStandardDD();
        if (j2eeJaxbTree != null) {
            XMLJ2EEEJBDDConverter j2eeConv = new XMLJ2EEEJBDDConverter();
            if (pc1 != null) {
                pc1.add((PermissionMap)j2eeConv.unmarshal(j2eeJaxbTree));
            } else {
                pc1 = (PermissionMap)j2eeConv.unmarshal(j2eeJaxbTree);
            }
        }
        dpc.getResourcePolicy(moduleInfo.getAppName(), true).add(pc1);
        JeusEjbDdType jeusJaxbTree = moduleInfo.getRuntimeDD();
        if (jeusJaxbTree != null) {
            XMLJEUSEJBDDConverter jeusConv = new XMLJEUSEJBDDConverter();
            dpc.getRolePolicy().add((PermissionMap)jeusConv.unmarshal(jeusJaxbTree));
        }
        return dpc;
    }
}

