/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.web;

import java.util.Iterator;

public class URLPattern {
    private String thePattern;

    public URLPattern(String pattern) {
        this.thePattern = pattern;
    }

    public String getQualifiedPattern(Iterator patts) {
        StringBuffer buf;
        block3: {
            block5: {
                block4: {
                    buf = new StringBuffer();
                    buf.append(this.getCompletePattern());
                    if (patts == null || this.isExactPattern()) break block3;
                    if (!this.isPathPrefixPattern()) break block4;
                    while (patts.hasNext()) {
                        URLPattern pattern = (URLPattern)patts.next();
                        if (pattern == null || (!pattern.isPathPrefixPattern() || this.equals(pattern) || !pattern.matches(this)) && (!pattern.isExactPattern() || !pattern.matches(this))) continue;
                        buf.append(":");
                        buf.append(pattern.getCompletePattern());
                    }
                    break block3;
                }
                if (!this.isExtensionPattern()) break block5;
                while (patts.hasNext()) {
                    URLPattern pattern = (URLPattern)patts.next();
                    if (pattern == null || !pattern.isPathPrefixPattern() && (!pattern.isExactPattern() || !pattern.matches(this))) continue;
                    buf.append(":");
                    buf.append(pattern.getCompletePattern());
                }
                break block3;
            }
            if (!this.isDefaultPattern()) break block3;
            while (patts.hasNext()) {
                URLPattern pattern = (URLPattern)patts.next();
                if (pattern == null || pattern.isDefaultPattern()) continue;
                buf.append(":");
                buf.append(pattern.getCompletePattern());
            }
        }
        return buf.toString();
    }

    public String getCompletePattern() {
        return this.thePattern;
    }

    public String getTrimmedPattern() {
        if (this.isPathPrefixPattern()) {
            return this.thePattern.substring(0, this.thePattern.length() - 2);
        }
        if (this.isExtensionPattern()) {
            return this.thePattern.substring(1);
        }
        return this.thePattern;
    }

    public boolean isPathPrefixPattern() {
        return this.thePattern != null && this.thePattern.endsWith("/*");
    }

    public boolean isExactPattern() {
        return this.thePattern != null && !this.isPathPrefixPattern() && !this.isExtensionPattern() && !this.isDefaultPattern() && this.thePattern.startsWith("/") && !this.thePattern.endsWith("/");
    }

    public boolean isExtensionPattern() {
        return this.thePattern != null && this.thePattern.startsWith("*.");
    }

    public boolean isDefaultPattern() {
        return this.thePattern != null && this.thePattern.equals("/");
    }

    public boolean matches(URLPattern otherPattern) {
        return this.doMatches(otherPattern, true);
    }

    private boolean doMatches(URLPattern otherPattern, boolean testOtherDirection) {
        block10: {
            if (otherPattern == null && this.thePattern == null) {
                return true;
            }
            if (otherPattern == null || this.thePattern == null) {
                return false;
            }
            if (this.equals(otherPattern)) {
                return true;
            }
            if (this.thePattern.equals("/*") || this.isDefaultPattern()) {
                return true;
            }
            try {
                if (!this.isPathPrefixPattern() || !otherPattern.thePattern.startsWith(this.getTrimmedPattern())) break block10;
                int plainLength = this.getTrimmedPattern().length();
                if (otherPattern.thePattern.length() > plainLength) {
                    if (otherPattern.thePattern.charAt(plainLength) == '/') {
                        return true;
                    }
                    break block10;
                }
                return true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (this.isExtensionPattern() && otherPattern.thePattern.endsWith(this.getTrimmedPattern())) {
            return true;
        }
        if (testOtherDirection) {
            return otherPattern.doMatches(this, false);
        }
        return false;
    }

    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (anotherObject == null) {
            return false;
        }
        if (anotherObject instanceof URLPattern) {
            return this.thePattern.equals(((URLPattern)anotherObject).thePattern);
        }
        return false;
    }

    public int hashCode() {
        return this.thePattern.hashCode();
    }
}

