/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.security.Principal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import jeus.security.base.CredentialFactory;
import jeus.security.base.Subject;
import jeus.security.impl.atnrep.db.GroupMemberTable;
import jeus.security.impl.atnrep.db.GroupTable;
import jeus.security.impl.atnrep.db.UserTable;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.util.Constants;
import jeus.security.util.DBConverter;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.InstanceMaker;

public class DBAccountConverter
extends DBConverter {
    private String domainName;
    private UserTable userTable = null;
    private GroupTable groupsTable = null;
    private GroupMemberTable groupMemberTable = null;

    public DBAccountConverter(String domainName, String vendor, String driver, String url, String username, String password) throws Exception {
        super(driver, url, username, password);
        this.domainName = domainName;
        this.vendor = vendor;
        this.create();
    }

    protected Object fromDBTable() throws Exception {
        super.connect();
        Vector<Subject> v = new Vector<Subject>();
        ResultSet groupResultSet = this.executeSelectQuery(this.groupsTable.getSelectQuery(), new String[]{this.domainName});
        while (groupResultSet.next()) {
            if (this.memoryGroupTable == null) {
                this.memoryGroupTable = new Hashtable();
            }
            GroupTable groupPrince = this.groupsTable.getObject(groupResultSet);
            String grClazz = Constants.DEFAULT_GROUP_PRINCIPAL_IMPL_CLASSNAME;
            GroupPrincipalImpl thePrince = (GroupPrincipalImpl)InstanceMaker.makeInstance(grClazz, new Object[]{groupPrince.getGroupName()});
            thePrince.setDescription(groupPrince.getDescription());
            String[] subgrpList = groupPrince.getSubgroups();
            for (int i = 0; i < subgrpList.length; ++i) {
                String subGrpName = subgrpList[i];
                GroupPrincipalImpl subGrpImpl = (GroupPrincipalImpl)this.memoryGroupTable.get(subGrpName);
                if (subGrpImpl == null) {
                    thePrince.addMember(new GroupPrincipalImpl(subGrpName));
                    continue;
                }
                thePrince.addMember(subGrpImpl);
            }
            this.memoryGroupTable.put(groupPrince.getGroupName(), thePrince);
        }
        groupResultSet.close();
        ResultSet userResultSet = this.executeSelectQuery(this.userTable.getPrinicpalQuery(), new String[]{this.domainName});
        if (userResultSet == null || userResultSet.getFetchSize() <= 0) {
            throw new Exception("user does not exist");
        }
        while (userResultSet.next()) {
            UserTable prince = this.userTable.getObject(userResultSet);
            String userName = prince.getUsername();
            Principal thePrince = (Principal)InstanceMaker.makeInstance(Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME, new Object[]{userName});
            Subject cur = new Subject(this.domainName, thePrince);
            ResultSet groupMemResultSet = this.executeSelectQuery(this.groupMemberTable.getSelectQuery(), new String[]{this.domainName, userName});
            while (groupMemResultSet.next()) {
                GroupMemberTable gMemPrince = this.groupMemberTable.getObject(groupMemResultSet);
                GroupPrincipalImpl groupImpl = (GroupPrincipalImpl)this.memoryGroupTable.get(gMemPrince.getGroupName());
                if (groupImpl != null) {
                    groupImpl.addMember(thePrince);
                    this.memoryGroupTable.put(gMemPrince.getGroupName(), groupImpl);
                    cur.getPrincipals().add(groupImpl);
                    continue;
                }
                throw new Exception(gMemPrince.getGroupName() + " group is not defined in database");
            }
            String password = prince.getPassword();
            if (password != null && !password.equals("")) {
                String onlyPassword = password;
                String algorithm = null;
                if (password.startsWith("{")) {
                    int endIdx = password.indexOf("}");
                    try {
                        algorithm = password.substring(1, endIdx);
                        if (EncryptionUtil.checkAlgorithm(algorithm)) {
                            onlyPassword = password.substring(endIdx + 1);
                        }
                    }
                    catch (StringIndexOutOfBoundsException se) {
                        // empty catch block
                    }
                }
                CredentialFactory factory = (CredentialFactory)InstanceMaker.makeInstance(Constants.DEFAULT_CREDENTIAL_FACTORY_IMPL_CLASSNAME, null);
                if (algorithm != null) {
                    factory.setProperty("algorithm", algorithm);
                }
                factory.setProperty("password", onlyPassword);
                cur.getCredentialFactories().add(factory);
                cur.addPasswordInfo(password);
            }
            v.add(cur);
            groupResultSet.close();
        }
        userResultSet.close();
        return v.toArray(new Subject[v.size()]);
    }

    protected Object fromDBTable(String userName) throws Exception {
        super.connect();
        Vector<Subject> v = new Vector<Subject>();
        ResultSet userResultSet = this.executeSelectQuery(this.userTable.getSelectQuery(), new String[]{this.domainName, userName});
        if (userResultSet == null || userResultSet.getFetchSize() <= 0) {
            throw new Exception("user does not exist");
        }
        while (userResultSet.next()) {
            UserTable prince = this.userTable.getObject(userResultSet);
            Principal thePrince = (Principal)InstanceMaker.makeInstance(Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME, new Object[]{userName});
            Subject cur = new Subject(this.domainName, thePrince);
            ResultSet groupMemResultSet = this.executeSelectQuery(this.groupMemberTable.getSelectQuery(), new String[]{this.domainName, userName});
            while (groupMemResultSet.next()) {
                GroupMemberTable gMemPrince = this.groupMemberTable.getObject(groupMemResultSet);
                GroupPrincipalImpl groupImpl = (GroupPrincipalImpl)this.memoryGroupTable.get(gMemPrince.getGroupName());
                if (groupImpl != null) {
                    groupImpl.addMember(thePrince);
                    this.memoryGroupTable.put(gMemPrince.getGroupName(), groupImpl);
                    cur.getPrincipals().add(groupImpl);
                    continue;
                }
                ResultSet groupResultSet = this.executeSelectQuery(this.groupsTable.getSelectQuery(), new String[]{this.domainName, gMemPrince.getGroupName()});
                if (groupResultSet == null || groupResultSet.getFetchSize() <= 0) {
                    throw new Exception(gMemPrince.getGroupName() + " group is not defined in database");
                }
                while (groupResultSet.next()) {
                    GroupTable gPrince = this.groupsTable.getObject(groupResultSet);
                    String grClazz = Constants.DEFAULT_GROUP_PRINCIPAL_IMPL_CLASSNAME;
                    groupImpl = (GroupPrincipalImpl)InstanceMaker.makeInstance(grClazz, new Object[]{gPrince.getGroupName()});
                    groupImpl.setDescription(gPrince.getDescription());
                    String[] subgrpList = gPrince.getSubgroups();
                    for (int i = 0; i < subgrpList.length; ++i) {
                        String subGrpName = subgrpList[i];
                        GroupPrincipalImpl subGrpImpl = (GroupPrincipalImpl)this.memoryGroupTable.get(subGrpName);
                        if (subGrpImpl == null) {
                            groupImpl.addMember(new GroupPrincipalImpl(subGrpName));
                            continue;
                        }
                        groupImpl.addMember(subGrpImpl);
                    }
                    this.memoryGroupTable.put(gPrince.getGroupName(), groupImpl);
                    cur.getPrincipals().add(groupImpl);
                }
            }
            String password = prince.getPassword();
            if (password != null && !password.equals("")) {
                String onlyPassword = password;
                String algorithm = null;
                if (password.startsWith("{")) {
                    int endIdx = password.indexOf("}");
                    try {
                        algorithm = password.substring(1, endIdx);
                        if (EncryptionUtil.checkAlgorithm(algorithm)) {
                            onlyPassword = password.substring(endIdx + 1);
                        }
                    }
                    catch (StringIndexOutOfBoundsException se) {
                        // empty catch block
                    }
                }
                CredentialFactory factory = (CredentialFactory)InstanceMaker.makeInstance(Constants.DEFAULT_CREDENTIAL_FACTORY_IMPL_CLASSNAME, null);
                if (algorithm != null) {
                    factory.setProperty("algorithm", algorithm);
                }
                factory.setProperty("password", onlyPassword);
                cur.getCredentialFactories().add(factory);
                cur.addPasswordInfo(password);
            }
            v.add(cur);
            groupMemResultSet.close();
        }
        userResultSet.close();
        return v.toArray(new Subject[v.size()]);
    }

    protected void toDBTable(Object object) throws Exception {
        super.connect();
        Vector querys = new Vector();
        Subject[] infos = (Subject[])object;
        this.addToDB(infos, querys);
        String[] queryList = new String[querys.size()];
        querys.toArray(queryList);
        this.executeUpdate(queryList);
        super.close();
    }

    private void addToDB(Subject[] infos, Vector querys) throws Exception {
        for (int i = 0; i < infos.length; ++i) {
            Subject info = infos[i];
            String userName = info.getPrincipal().getName();
            this.userTable.setDomain(this.domainName);
            this.userTable.setUsername(userName);
            this.userTable.setPassword(info.getOriginPassword());
            ResultSet userResultSet = this.executeSelectQuery(this.userTable.getSelectQuery(), new String[]{this.domainName, userName});
            if (userResultSet.getRow() == 0) {
                querys.add(this.userTable.execInsertQuery());
            } else {
                querys.add(this.userTable.execUpdateQuery());
            }
            userResultSet.close();
            for (Principal principal : info.getPrincipals()) {
                GroupPrincipalImpl gImpl;
                if (((Object)principal).equals(info.getPrincipal()) || (gImpl = (GroupPrincipalImpl)this.memoryGroupTable.get(userName = info.getPrincipal().getName())) == null) continue;
                this.groupsTable.setDomain(this.domainName);
                this.groupsTable.setGroupName(gImpl.getName());
                this.groupsTable.setDescription(gImpl.getDescription());
                Principal[] subgImpl = gImpl.getSubGroups();
                for (int j = 0; j < subgImpl.length; ++j) {
                    this.groupsTable.addSubgroups(subgImpl[j].getName());
                }
                ResultSet groupResultSet = this.executeSelectQuery(this.groupsTable.getSelectQuery(), new String[]{this.domainName, userName});
                if (groupResultSet.getRow() == 0) {
                    querys.add(this.groupsTable.execInsertQuery());
                } else {
                    querys.add(this.groupsTable.execUpdateQuery());
                }
                groupResultSet.close();
            }
        }
    }

    public void create() throws Exception {
        this.userTable = new UserTable(this.vendor, this.domainName);
        this.groupsTable = new GroupTable(this.vendor, this.domainName);
        this.groupMemberTable = new GroupMemberTable(this.vendor, this.domainName);
        if (!super.checkExist(this.userTable.getCheckquery(), this.domainName)) {
            ArrayList initDataSqlList = new ArrayList();
            initDataSqlList.addAll(this.userTable.getInitQuery());
            initDataSqlList.addAll(this.groupsTable.getInitQuery());
            initDataSqlList.addAll(this.groupMemberTable.getInitQuery());
            String[] initDataSqls = new String[initDataSqlList.size()];
            initDataSqlList.toArray(initDataSqls);
        }
    }
}

