/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.security.Permission;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.atnrep.DistributedMemoryAuthenticationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.spi.SubjectNotExistsException;
import jeus.security.util.DBConverter;
import jeus.security.util.DataReloadTask;
import jeus.util.ScheduledExecutor;

public class DBPersistedDistributedMemoryAuthenticationRepositoryService
extends DistributedMemoryAuthenticationRepositoryService {
    protected DBConverter conv;
    protected String vendor;
    protected String driver;
    protected String url;
    protected String username;
    protected String password;
    protected int updateOption = 2;
    protected DataReloadTask reloadTask;

    protected void doCreate() throws ServiceException, SecurityException {
        super.doCreate();
        try {
            this.vendor = this.getProperty("vendor");
            if (this.vendor == null || this.vendor.equals("")) {
                throw new Exception("vendor is not set");
            }
            this.driver = this.getProperty("driver");
            if (this.driver == null || this.driver.equals("")) {
                throw new Exception("driver is not set");
            }
            this.url = this.getProperty("url");
            if (this.url == null || this.url.equals("")) {
                throw new Exception("url is not set");
            }
            this.username = this.getProperty("username");
            if (this.username == null || this.username.equals("")) {
                throw new Exception("username is not set");
            }
            this.password = this.getProperty("password");
            if (this.password == null || this.password.equals("")) {
                throw new Exception("password is not set");
            }
            String option = this.getProperty("updateOption");
            if (option != null) {
                String tmp = option.trim();
                this.updateOption = tmp.equalsIgnoreCase("forecd") ? 0 : (tmp.equalsIgnoreCase("repeated") ? 1 : 2);
            }
            if (this.updateOption == 1) {
                this.reloadTask = new DataReloadTask(this);
                long interval = -1L;
                String value = this.getProperty("interval");
                if (value != null) {
                    interval = Long.parseLong(value);
                }
                if (interval > 0L) {
                    ScheduledExecutor.getInstance().scheduleWithFixedDelay(this.reloadTask, interval, interval);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating DBPersistedDistributedMemoryAuthenticationRepositoryService: exception occured", e);
        }
    }

    protected void doDestroy() {
        this.conv.close();
        super.doDestroy();
    }

    protected Subject doGetSubject(String name) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_SUBJECT_PERMISSION);
        Subject[] subjects = null;
        if (this.updateOption == 0) {
            subjects = this.refreshRead(name);
        } else {
            Subject loadSubject;
            try {
                loadSubject = this.subjectContainer.getSubject(name);
            }
            catch (SubjectNotExistsException e) {
                loadSubject = null;
            }
            if (loadSubject == null) {
                subjects = this.refreshRead(name);
            } else {
                return loadSubject;
            }
        }
        for (int i = 0; i < subjects.length; ++i) {
            super.doAddSubject(subjects[i]);
        }
        this.subjectContainer.setGroupTable(this.conv.getGroupsTable());
        return this.subjectContainer.getSubject(name);
    }

    public void refreshRepositryService() throws ServiceException {
        if (this.updateOption == 2) {
            this.refreshRead();
        } else {
            this.clearSubject();
        }
    }

    protected synchronized void doAddSubject(Subject subject) throws ServiceException, SecurityException {
        super.doAddSubject(subject);
    }

    protected synchronized void doRemoveSubject(Subject subject) throws ServiceException, SecurityException {
        super.doRemoveSubject(subject);
    }

    protected synchronized void doRemoveSubject(String name) throws ServiceException, SecurityException {
        super.doRemoveSubject(name);
    }

    public void doSave() throws ServiceException {
        this.refreshWrite();
    }

    private void refreshWrite() throws ServiceException {
        try {
            if (SecurityInstaller.getEnvironment().master) {
                this.conv.marshal(this.subjectContainer.getSubjectsAsArray());
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed writing subjects DB: exception occured", e);
        }
    }

    public void refreshRead() throws ServiceException {
        try {
            Subject[] subjects = (Subject[])this.conv.unmarshal();
            this.subjectContainer.clear();
            this.subjectContainer.addSubjectsFromArray(subjects);
            this.subjectContainer.setGroupTable(this.conv.getGroupsTable());
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading subjects DB: exception occured", e);
        }
    }

    public void clearSubject() {
        this.subjectContainer.clear();
    }

    public Subject[] refreshRead(String principalName) throws ServiceException {
        try {
            Subject[] subjects = (Subject[])this.conv.unmarshal(principalName);
            if (subjects.length == 0) {
                new Exception("subject does not exist");
            }
            return subjects;
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading subjects DB: exception occured", e);
        }
    }
}

