/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.security.Principal;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jeus.security.base.CredentialFactory;
import jeus.security.base.Subject;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.util.Constants;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.InstanceMaker;
import jeus.security.util.XMLConverter;
import jeus.xml.binding.jeusDD.AccountsType;
import jeus.xml.binding.jeusDD.GroupType;
import jeus.xml.binding.jeusDD.GroupsType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.UserType;
import jeus.xml.binding.jeusDD.UsersType;

public class XMLAccountConverter
extends XMLConverter {
    private ObjectFactory of;
    private String domainName;
    private Map groupsTable = new Hashtable();

    public XMLAccountConverter(String domainName) throws Exception {
        super("jeus.xml.binding.jeusDD");
        this.domainName = domainName;
        this.of = new ObjectFactory();
    }

    protected Object fromXMLTree(Object contentTree) throws Exception {
        UsersType usersType;
        AccountsType data = (AccountsType)contentTree;
        Vector<Subject> v = new Vector<Subject>();
        GroupsType groupsType = data.getGroups();
        if (groupsType != null) {
            List groups = groupsType.getGroup();
            for (GroupType groupType : groups) {
                if (groupType.getName() == null) continue;
                String grClazz = Constants.DEFAULT_GROUP_PRINCIPAL_IMPL_CLASSNAME;
                GroupPrincipalImpl thePrince = (GroupPrincipalImpl)InstanceMaker.makeInstance(grClazz, new Object[]{groupType.getName()});
                if (groupType.isSetDescription()) {
                    thePrince.setDescription(groupType.getDescription());
                }
                List subgrpList = groupType.getSubgroup();
                for (int i = 0; i < subgrpList.size(); ++i) {
                    String subGrpName = (String)subgrpList.get(i);
                    GroupPrincipalImpl subGrpImpl = (GroupPrincipalImpl)this.groupsTable.get(subGrpName);
                    if (subGrpImpl == null) {
                        thePrince.addMember(new GroupPrincipalImpl(subGrpName));
                        continue;
                    }
                    thePrince.addMember(subGrpImpl);
                }
                this.groupsTable.put(groupType.getName(), thePrince);
            }
        }
        if ((usersType = data.getUsers()) == null) {
            return v.toArray(new Subject[0]);
        }
        List users = usersType.getUser();
        for (UserType user : users) {
            String desc = user.getDescription();
            String clazz = Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME;
            Principal thePrince = (Principal)InstanceMaker.makeInstance(clazz, new Object[]{user.getName()});
            Subject cur = new Subject(this.domainName, thePrince);
            cur.setDescription(desc);
            List groups = user.getGroup();
            for (String groupPrincipal : groups) {
                GroupPrincipalImpl groupImpl = (GroupPrincipalImpl)this.groupsTable.get(groupPrincipal);
                if (groupImpl != null) {
                    groupImpl.addMember(thePrince);
                    this.groupsTable.put(groupPrincipal, groupImpl);
                    cur.getPrincipals().add(groupImpl);
                    continue;
                }
                throw new Exception(groupPrincipal + " group is not defined in xml tag <groups>");
            }
            String password = user.getPassword();
            if (password != null && !password.equals("")) {
                String onlyPassword = password;
                String algorithm = null;
                if (password.startsWith("{")) {
                    int endIdx = password.indexOf("}");
                    try {
                        algorithm = password.substring(1, endIdx);
                        if (EncryptionUtil.checkAlgorithm(algorithm)) {
                            onlyPassword = password.substring(endIdx + 1);
                        }
                    }
                    catch (StringIndexOutOfBoundsException se) {
                        // empty catch block
                    }
                }
                CredentialFactory factory = (CredentialFactory)InstanceMaker.makeInstance(Constants.DEFAULT_CREDENTIAL_FACTORY_IMPL_CLASSNAME, null);
                if (algorithm != null) {
                    factory.setProperty("algorithm", algorithm);
                }
                factory.setProperty("password", onlyPassword);
                cur.getCredentialFactories().add(factory);
                cur.getPrivateCredentials().add(factory.getCredential());
                cur.addPasswordInfo(password);
            }
            v.add(cur);
        }
        return v.toArray(new Subject[v.size()]);
    }

    protected Object toXMLTree(Object object, Object tree) throws Exception {
        Subject[] infos = (Subject[])object;
        if (tree == null) {
            tree = this.of.createAccountsType();
        }
        AccountsType data = (AccountsType)tree;
        UsersType users = this.of.createUsersType();
        this.addToTree(infos, users);
        data.setUsers(users);
        GroupsType groupsType = this.of.createGroupsType();
        List groups = groupsType.getGroup();
        GroupPrincipalImpl[] groupList = (GroupPrincipalImpl[])AuthenticationRepositoryService.getGroupList();
        if (groupList == null) {
            List userList = users.getUser();
            for (int i = 0; i < userList.size(); ++i) {
                UserType user = (UserType)userList.get(i);
                List userGroups = user.getGroup();
                for (int j = 0; j < userGroups.size(); ++j) {
                    GroupType group = this.of.createGroupType();
                    group.setName((String)userGroups.get(j));
                    if (groups.contains(group)) continue;
                    groups.add(group);
                }
            }
        } else {
            for (int i = 0; i < groupList.length; ++i) {
                GroupType group = this.of.createGroupType();
                GroupPrincipalImpl groupObj = groupList[i];
                group.setName(groupObj.getName());
                group.setDescription(groupObj.getDescription());
                groups.add(group);
            }
        }
        data.setGroups(groupsType);
        ObjectFactory fac = new ObjectFactory();
        return fac.createAccounts(data);
    }

    private void addToTree(Subject[] infos, UsersType users) throws Exception {
        for (int i = 0; i < infos.length; ++i) {
            Subject info = infos[i];
            UserType user = this.of.createUserType();
            user.setDescription(info.getDescription());
            user.setName(info.getPrincipal().getName());
            for (Principal principal : info.getPrincipals()) {
                if (((Object)principal).equals(info.getPrincipal())) continue;
                user.getGroup().add(principal.getName());
            }
            user.setPassword(infos[i].getOriginPassword());
            users.getUser().add(user);
        }
    }

    public Map getGroupsTable() {
        return this.groupsTable;
    }

    public void setGroupsTable(Map groupsTable) {
        this.groupsTable = groupsTable;
    }
}

