/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.atnrep;

import java.util.List;
import java.util.Map;
import jeus.security.util.XMLConverter;
import jeus.xml.binding.jeusDD.CertType;
import jeus.xml.binding.jeusDD.CertUserMapType;
import jeus.xml.binding.jeusDD.CertUserType;
import jeus.xml.binding.jeusDD.ObjectFactory;

public class XMLCertUserMapConverter
extends XMLConverter {
    private ObjectFactory of = new ObjectFactory();
    private Map certUserMap;

    public XMLCertUserMapConverter(Map certUserMap) throws Exception {
        super("jeus.xml.binding.jeusDD");
        this.certUserMap = certUserMap;
    }

    protected Object fromXMLTree(Object contentTree) throws Exception {
        CertUserMapType data = (CertUserMapType)contentTree;
        List certUserList = data.getCertUser();
        for (CertUserType certToUser : certUserList) {
            String certAttrValue;
            String username = certToUser.getUsername();
            CertType cert = certToUser.getCert();
            if (cert.isSetAlias()) {
                certAttrValue = cert.getAlias();
            } else if (cert.isSetSKI()) {
                certAttrValue = cert.getSKI();
            } else if (cert.isSetSubjectDN()) {
                certAttrValue = cert.getSubjectDN();
            } else {
                if (!cert.isSetIssuer() || !cert.isSetSerialNo()) continue;
                certAttrValue = cert.getIssuer() + cert.getSerialNo();
            }
            this.certUserMap.put(certAttrValue, username);
        }
        return null;
    }

    protected Object toXMLTree(Object object, Object tree) throws Exception {
        return null;
    }
}

