/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import jeus.security.base.ClientService;
import jeus.security.base.Domain;
import jeus.security.base.NetworkMessage;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.spi.AuthorizationService;
import jeus.security.spi.LoginService;
import jeus.security.spi.NetworkService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;

public class ClientAuthorizationRepositoryService
extends AuthorizationRepositoryService
implements ClientService {
    Hashtable cache = new Hashtable();
    private static boolean enableClientCache;

    public Object getMBean() {
        return null;
    }

    protected MBeanInfo getMBeanInfo() {
        return null;
    }

    protected void doCreate() {
        enableClientCache = SecurityInstaller.getEnvironment().isEnableClientAznCache();
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    public void removeCache(String node) {
        this.cache.remove(node);
    }

    protected Policy doGetPolicy(String contextId) throws ServiceException, SecurityException {
        Policy policy;
        if (enableClientCache && (policy = (Policy)this.getCache().get(contextId)) != null) {
            return policy;
        }
        policy = (Policy)NetworkService.sendMessage(new NetworkMessage(8, LoginService.getCurrentSubject(), new Serializable[]{contextId}), false);
        this.getCache().put(contextId, policy);
        return policy;
    }

    protected Set doGetPolicyIds() throws ServiceException, SecurityException {
        if (enableClientCache) {
            return this.getCache().keySet();
        }
        return (Set)NetworkService.sendMessage(new NetworkMessage(9, LoginService.getCurrentSubject(), null), false);
    }

    protected Policy[] doGetPoliciesAsArray() throws ServiceException, SecurityException {
        return (Policy[])this.getCache().values().toArray(new Subject[0]);
    }

    protected void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        NetworkService.sendMessage(new NetworkMessage(10, LoginService.getCurrentSubject(), new Serializable[]{policy}), false);
        Set ids = policy.getResourcePolicyIds();
        for (String contextId : ids) {
            this.getCache().put(contextId, policy);
        }
    }

    protected void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException, SecurityException {
        block4: {
            NetworkService.sendMessage(new NetworkMessage(11, LoginService.getCurrentSubject(), new Serializable[]{policy}), false);
            Set ids = policy.getResourcePolicyIds();
            for (String contextId : ids) {
                this.getCache().remove(contextId);
            }
            try {
                Service service = Domain.SHARED_DOMAIN.getOneService(AuthorizationService.class);
                if (service instanceof ClientService) {
                    String node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
                    ClientService clientService = (ClientService)((Object)service);
                    clientService.removeCache(node);
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._14_LEVEL)) break block4;
                LoggerUtil.logger.log(JeusMessage_Security._14_LEVEL, JeusMessage_Security._14, (Throwable)e);
            }
        }
    }

    protected void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException, SecurityException {
        block3: {
            NetworkService.sendMessage(new NetworkMessage(12, LoginService.getCurrentSubject(), new Serializable[]{contextId}), false);
            this.getCache().remove(contextId);
            try {
                Service service = Domain.SHARED_DOMAIN.getOneService(AuthorizationService.class);
                if (service instanceof ClientService) {
                    String node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
                    ClientService clientService = (ClientService)((Object)service);
                    clientService.removeCache(node);
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._14_LEVEL)) break block3;
                LoggerUtil.logger.log(JeusMessage_Security._14_LEVEL, JeusMessage_Security._14, (Throwable)e);
            }
        }
    }

    protected void doSave() throws ServiceException, SecurityException {
        NetworkService.sendMessage(new NetworkMessage(17, LoginService.getCurrentSubject(), null), false);
    }

    private Hashtable getCache() {
        String node = SecurityInstaller.getEnvironment().localHostName + ":" + SecurityInstaller.getEnvironment().baseSecurityPort;
        return this.getCache(node);
    }

    private Hashtable getCache(String node) {
        Object hash = this.cache.get(node);
        if (hash == null) {
            hash = new Hashtable();
            this.cache.put(node, hash);
            return (Hashtable)hash;
        }
        return (Hashtable)hash;
    }

    protected void refreshRepositryService() throws ServiceException {
    }

    public Object readPoliciesInRepository() throws ServiceException {
        return null;
    }

    public void writePoliciesToRepository(Object policies) throws ServiceException {
    }
}

