/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.security.Permission;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.aznrep.DistributedMemoryAuthorizationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.DBConverter;
import jeus.security.util.DataReloadTask;
import jeus.util.ScheduledExecutor;

public class DBPersistedDistributedMemoryAuthorizationRepositoryService
extends DistributedMemoryAuthorizationRepositoryService {
    protected DBConverter conv;
    protected String vendor;
    protected String driver;
    protected String url;
    protected String username;
    protected String password;
    protected int updateOption = 0;
    protected DataReloadTask reloadTask;

    protected void doCreate() throws ServiceException, SecurityException {
        super.doCreate();
        try {
            this.vendor = this.getProperty("vendor");
            if (this.vendor == null || this.vendor.equals("")) {
                throw new Exception("vendor is not set");
            }
            this.driver = this.getProperty("driver");
            if (this.driver == null || this.driver.equals("")) {
                throw new Exception("driver is not set");
            }
            this.url = this.getProperty("url");
            if (this.url == null || this.url.equals("")) {
                throw new Exception("url is not set");
            }
            this.username = this.getProperty("username");
            if (this.username == null || this.username.equals("")) {
                throw new Exception("username is not set");
            }
            this.password = this.getProperty("password");
            if (this.password == null || this.password.equals("")) {
                throw new Exception("password is not set");
            }
            String option = this.getProperty("updateOption");
            if (option != null) {
                this.updateOption = Integer.parseInt(option);
            }
            if (this.updateOption == 1) {
                this.reloadTask = new DataReloadTask(this);
                long interval = -1L;
                String value = this.getProperty("interval");
                if (value != null) {
                    interval = Long.parseLong(value);
                }
                if (interval > 0L) {
                    ScheduledExecutor.getInstance().scheduleWithFixedDelay(this.reloadTask, interval, interval);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed creating DBPersistedDistributedMemoryAuthorizationRepositoryService: exception occured", e);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
    }

    protected Policy doGetPolicy(String contextId) throws ServiceException, SecurityException {
        Policy policy;
        LoginService.checkPermission((Permission)GET_POLICY_PERMISSION);
        if (this.updateOption == 0) {
            policy = this.refreshRead(contextId);
        } else {
            try {
                policy = this.policyContainer.getPolicy(contextId);
            }
            catch (PolicyNotExistsException e) {
                policy = null;
            }
            if (policy == null) {
                policy = this.refreshRead(contextId);
            }
        }
        super.doAddPolicy(policy, true);
        return policy;
    }

    protected void refreshRepositryService() throws ServiceException {
        if (this.updateOption == 2) {
            this.refreshRead();
        } else {
            this.clearPolicy();
        }
    }

    public Object readPoliciesInRepository() throws ServiceException {
        try {
            return (Policy[])this.conv.unmarshal();
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading policies DB: exception occured", e);
        }
    }

    public void writePoliciesToRepository(Object policies) throws ServiceException {
        try {
            if (SecurityInstaller.getEnvironment().master) {
                this.conv.marshal(policies);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed writing policies DB: exception occured", e);
        }
    }

    protected synchronized void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        super.doAddPolicy(policy, localAdd);
    }

    protected synchronized void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException, SecurityException {
        super.doRemovePolicy(policy, localRemove);
    }

    protected synchronized void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException, SecurityException {
        super.doRemovePolicy(contextId, localRemove);
    }

    protected void doSave() throws ServiceException {
        this.refreshWrite();
    }

    private void refreshWrite() throws ServiceException {
        block5: {
            try {
                if (!SecurityInstaller.getEnvironment().master) break block5;
                try {
                    Policy p = this.policyContainer.getPolicy("default");
                    if (p != null) {
                        this.conv.marshal(new Policy[]{p});
                    }
                }
                catch (PolicyNotExistsException p) {
                    return;
                }
            }
            catch (Exception e) {
                throw new ServiceException("Failed writing policies DB: exception occured", e);
            }
        }
    }

    public void clearPolicy() {
        this.policyContainer.clearPolicies();
    }

    protected void refreshRead() throws ServiceException {
        try {
            this.policyContainer.clearPolicies();
            Policy[] policies = (Policy[])this.conv.unmarshal();
            this.policyContainer.addPoliciesFromArray(policies);
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading policies DB: exception occured", e);
        }
    }

    private Policy refreshRead(String contextId) throws ServiceException {
        try {
            Policy policy = (Policy)this.conv.unmarshal(contextId);
            if (policy == null) {
                new Exception("policy does not exist");
            }
            this.policyContainer.addPolicy(policy);
            return policy;
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading policies DB: exception occured", e);
        }
    }
}

