/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jeus.security.base.Environment;
import jeus.security.base.NetworkMessage;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.aznrep.MemoryAuthorizationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.NetworkService;

public class DistributedMemoryAuthorizationRepositoryService
extends MemoryAuthorizationRepositoryService {
    private Environment env;

    private long getSynchTrigger() {
        String s = this.getProperty("synchtrigger");
        if (s != null) {
            return Long.parseLong(s);
        }
        return 15000L;
    }

    protected void doCreate() throws ServiceException, SecurityException {
        super.doCreate();
        this.env = this.getRemoteEnvToDownloadFrom();
        if (this.env == null) {
            return;
        }
        Set remotePolicies = this.getRemotePolicies();
        if (remotePolicies != null && remotePolicies.size() > 0) {
            for (Policy p : remotePolicies) {
                this.policyContainer.addPolicy(p);
            }
        }
    }

    protected void doDestroy() {
    }

    protected void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        super.doAddPolicy(policy, localAdd);
        if (!localAdd) {
            NetworkService.sendMessage(new NetworkMessage(10, LoginService.getCurrentSubject(), 1, new Serializable[]{policy}), true);
        }
    }

    protected void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException, SecurityException {
        super.doRemovePolicy(policy, localRemove);
        if (!localRemove) {
            NetworkService.sendMessage(new NetworkMessage(11, LoginService.getCurrentSubject(), 1, new Serializable[]{policy}), true);
        }
    }

    protected void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException, SecurityException {
        super.doRemovePolicy(contextId, localRemove);
        if (!localRemove) {
            NetworkService.sendMessage(new NetworkMessage(12, LoginService.getCurrentSubject(), NetworkService.getCurrentBroadcastType(), new Serializable[]{contextId}), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getRemotePolicies() throws ServiceException, SecurityException {
        LoginService.loginCodeSubject();
        HashSet<Policy> result = null;
        try {
            Set ids = (Set)NetworkService.sendMessage(new NetworkMessage(9, LoginService.getCurrentSubject(), null), false, this.env);
            Iterator iter = ids.iterator();
            result = new HashSet<Policy>();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                Policy p = (Policy)NetworkService.sendMessage(new NetworkMessage(8, LoginService.getCurrentSubject(), new Serializable[]{id}), false, this.env);
                result.add(p);
            }
        }
        finally {
            LoginService.logout();
        }
        return result;
    }

    private Environment getRemoteEnvToDownloadFrom() throws SecurityException, ServiceException {
        long now = System.currentTimeMillis();
        Environment[] remoteEnvs = NetworkService.getRemoteEnvironments();
        if (remoteEnvs == null) {
            return null;
        }
        for (int i = 0; i < remoteEnvs.length; ++i) {
            if (remoteEnvs[i].startTime == -1L || Math.abs(now - remoteEnvs[i].startTime) <= this.getSynchTrigger() || !remoteEnvs[i].master) continue;
            return remoteEnvs[i];
        }
        return null;
    }
}

