/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.io.File;
import java.security.Permission;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.Role;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.aznrep.JACCPrincipalRoleMapper;
import jeus.security.impl.aznrep.XMLPoliciesConverter;
import jeus.security.impl.jacc.JACCDefaultPrincipalRoleMapper;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JACCUtil;
import jeus.security.util.NameAndPathUtil;

public class JACCAuthorizationRepositoryService
extends AuthorizationRepositoryService {
    private static final String DEFAULT_JACC_POLICY_PROVIDER_CLASSNAME = "jeus.security.impl.jacc.JACCPolicyWrapper";
    private static final String DEFAULT_JACC_POLICY_CONFIGURATION_FACTORY_CLASSNAME = "jeus.security.impl.jacc.JACCPolicyConfigurationFactoryImpl";
    private static final String DEFAULT_JACC_PRINCIPAL_ROLE_MAPPER_CLASSNAME = "jeus.security.impl.jacc.JACCDefaultPrincipalRoleMapper";
    private static final String JACC_PRINCIPAL_ROLE_MAPPER_PROPERTY_KEY = "jeus.security.jacc.principalRoleMapper";
    private static PolicyConfigurationFactory thePolicyConfigurationFactory = null;
    private static JACCPrincipalRoleMapper thePrincipalRoleMapper = null;

    protected synchronized void doCreate() throws ServiceException {
        JACCUtil.setJACCUsed(true);
        if (thePolicyConfigurationFactory == null) {
            try {
                String jaccPolicyProviderClassName = System.getProperty("javax.security.jacc.policy.provider");
                if (jaccPolicyProviderClassName == null) {
                    System.setProperty("javax.security.jacc.policy.provider", DEFAULT_JACC_POLICY_PROVIDER_CLASSNAME);
                    jaccPolicyProviderClassName = DEFAULT_JACC_POLICY_PROVIDER_CLASSNAME;
                }
                java.security.Policy thePolicy = (java.security.Policy)Class.forName(jaccPolicyProviderClassName).newInstance();
                java.security.Policy.setPolicy(thePolicy);
                String jaccPolicyConfigurationFactoryClassName = null;
                jaccPolicyConfigurationFactoryClassName = System.getProperty("javax.security.jacc.PolicyConfigurationFactory.provider");
                if (jaccPolicyConfigurationFactoryClassName == null) {
                    jaccPolicyConfigurationFactoryClassName = DEFAULT_JACC_POLICY_CONFIGURATION_FACTORY_CLASSNAME;
                    System.setProperty("javax.security.jacc.PolicyConfigurationFactory.provider", DEFAULT_JACC_POLICY_CONFIGURATION_FACTORY_CLASSNAME);
                }
                thePolicyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                if (thePrincipalRoleMapper == null) {
                    String mapperClassname = System.getProperty(JACC_PRINCIPAL_ROLE_MAPPER_PROPERTY_KEY);
                    if (mapperClassname == null && jaccPolicyConfigurationFactoryClassName != null && jaccPolicyConfigurationFactoryClassName.equals(DEFAULT_JACC_POLICY_CONFIGURATION_FACTORY_CLASSNAME)) {
                        mapperClassname = DEFAULT_JACC_PRINCIPAL_ROLE_MAPPER_CLASSNAME;
                    }
                    if (mapperClassname != null) {
                        Class<?> c = Class.forName(mapperClassname);
                        thePrincipalRoleMapper = (JACCPrincipalRoleMapper)c.newInstance();
                    }
                }
            }
            catch (Exception e) {
                throw new ServiceException("Failed to create JACCAuthorizationRepositoryService: exception occured", e);
            }
        }
        try {
            String baseDir;
            File theFile;
            String filename = this.getProperty("filename");
            if (filename == null) {
                String baseDir2 = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory);
                filename = baseDir2 + NameAndPathUtil.getPathWithEndingSeparator(this.getDomain().getName()) + "policies.xml";
            }
            if (!(theFile = new File(filename)).exists() && !(theFile = new File(filename = (baseDir = NameAndPathUtil.getPathWithEndingSeparator(SecurityInstaller.getEnvironment().baseSecurityConfigurationDirectory)) + NameAndPathUtil.getPathWithEndingSeparator("SYSTEM_DOMAIN") + "policies.xml")).exists()) {
                return;
            }
            XMLPoliciesConverter conv = new XMLPoliciesConverter();
            Policy[] policies = (Policy[])conv.unmarshal(theFile);
            for (int i = 0; i < policies.length; ++i) {
                this.doAddPolicy(policies[i], false);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed reading policies XML file: exception occured", e);
        }
    }

    protected void doDestroy() {
        JACCUtil.setJACCUsed(false);
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException {
        try {
            Iterator rrIds = policy.getResourcePolicyIds().iterator();
            PolicyConfiguration prevPCfg = null;
            PolicyConfiguration pCfg = null;
            Vector<PolicyConfiguration> allPC = new Vector<PolicyConfiguration>();
            while (rrIds.hasNext()) {
                String contextId = (String)rrIds.next();
                PermissionMap pm = policy.getResourcePolicy(contextId);
                pCfg = thePolicyConfigurationFactory.getPolicyConfiguration(contextId, false);
                this.addPermissions(pm.getExcludedPermissions().iterator(), pCfg, true);
                this.addPermissions(pm.getUncheckedPermissions().iterator(), pCfg, false);
                Iterator owners = pm.getCheckedPermissionOwners().iterator();
                if (owners != null) {
                    while (owners.hasNext()) {
                        Role role;
                        Iterator permissions;
                        Object o2 = owners.next();
                        if (o2 == null || !(o2 instanceof Role) || (permissions = pm.getCheckedPermissions(role = (Role)o2).iterator()) == null) continue;
                        while (permissions.hasNext()) {
                            Object o3 = permissions.next();
                            if (o3 == null || !(o3 instanceof Permission)) continue;
                            Permission permission = (Permission)o3;
                            pCfg.addToRole(role.getName(), permission);
                        }
                    }
                }
                if (prevPCfg != null) {
                    pCfg.linkConfiguration(prevPCfg);
                }
                prevPCfg = pCfg;
                allPC.add(pCfg);
                if (thePrincipalRoleMapper == null || pCfg == null) continue;
                thePrincipalRoleMapper.addPrincipalRoleMapping(policy.getRolePolicy(), pCfg.getContextID());
            }
            for (PolicyConfiguration pc : allPC) {
                pc.commit();
            }
            java.security.Policy.getPolicy().refresh();
        }
        catch (Exception e) {
            throw new ServiceException("Failed adding Policy in JACCAuthorizationRepositoryService: exception occured", e);
        }
    }

    private void addPermissions(Iterator permissions, PolicyConfiguration pCfg, boolean excluded) throws Exception {
        if (permissions != null) {
            while (permissions.hasNext()) {
                Object o = permissions.next();
                if (o == null || !(o instanceof Permission)) continue;
                Permission permission = (Permission)o;
                if (excluded) {
                    pCfg.addToExcludedPolicy(permission);
                    continue;
                }
                pCfg.addToUncheckedPolicy(permission);
            }
        }
    }

    protected void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException {
        throw new ServiceException("Failed removing Policy in JACCAuthorizationRepositoryService: operation removePolicy(Policy) is not supported by JACC adapter");
    }

    protected Policy doGetPolicy(String contextId) throws ServiceException {
        try {
            if (thePolicyConfigurationFactory.inService(contextId)) {
                Policy jeusPolicy = new Policy();
                PermissionMap principalRoleMap = JACCDefaultPrincipalRoleMapper.getPrincipalRoleMapping(contextId);
                if (principalRoleMap != null) {
                    jeusPolicy.getRolePolicy().add(principalRoleMap);
                }
                return jeusPolicy;
            }
            throw new ServiceException("Failed get Policy in JACCAuthorizationRepositoryService: the policy for context id " + contextId + " does not exist or is not in service");
        }
        catch (PolicyContextException e) {
            throw new ServiceException("Failed get Policy in JACCAuthorizationRepositoryService: exception occured", e);
        }
    }

    protected Set doGetPolicyIds() throws ServiceException {
        throw new ServiceException("Failed getting Policy IDs in JACCAuthorizationRepositoryService: operation getPolicyIds() is not supported by JACC adapter");
    }

    protected Policy[] doGetPoliciesAsArray() throws ServiceException, SecurityException {
        throw new ServiceException("Failed getting Policies in JACCAuthorizationRepositoryService: operation getPolicyIds() is not supported by JACC adapter");
    }

    protected void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException {
        try {
            if (!thePolicyConfigurationFactory.inService(contextId)) {
                throw new ServiceException("Failed removing Policy in JACCAuthorizationRepositoryService: the policy for context id " + contextId + " does not exist or is not in service");
            }
            thePolicyConfigurationFactory.getPolicyConfiguration(contextId, true);
            java.security.Policy.getPolicy().refresh();
        }
        catch (Exception e) {
            throw new ServiceException("Failed removing Policy in JACCAuthorizationRepositoryService: exception occured", e);
        }
    }

    protected void doSave() throws ServiceException {
    }

    protected void refreshRepositryService() throws ServiceException {
    }

    public Object readPoliciesInRepository() throws ServiceException {
        return null;
    }

    public void writePoliciesToRepository(Object policies) throws ServiceException {
    }
}

