/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.security.Permission;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.security.PolicyMo;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.resource.CacheInfo;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.PolicyManager;

public class JeusMemoryAuthorizationRepositoryService
extends AuthorizationRepositoryService {
    protected PolicyManager policyManager;
    protected PolicyMo policyMo = null;

    protected void doCreate() throws ServiceException, SecurityException {
        CacheInfo cacheInfo = this.getDomain().getCacheInfo();
        if (cacheInfo == null) {
            cacheInfo = new CacheInfo(20, 100, 1800000L);
            this.getDomain().setCacheInfo(cacheInfo);
            this.policyManager = new PolicyManager(cacheInfo.getMin(), cacheInfo.getMax(), cacheInfo.getTimeout());
        } else {
            this.policyManager = new PolicyManager(cacheInfo.getMin(), cacheInfo.getMax(), cacheInfo.getTimeout());
        }
    }

    protected void doDestroy() {
        this.policyManager.stop();
        this.policyManager.clear();
        this.policyManager = null;
    }

    public void doRegisterMBean(ObjectName parent) {
        block2: {
            try {
                this.policyMo = (PolicyMo)PolicyMo.createMBean("Policy", parent, this);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._7_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._7_LEVEL, JeusMessage_Security._7, (Throwable)e);
            }
        }
    }

    protected Policy doGetPolicy(String contextId) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_POLICY_PERMISSION);
        return this.policyManager.getPolicy(contextId);
    }

    protected Set doGetPolicyIds() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_POLICY_PERMISSION);
        return this.policyManager.getContextIds();
    }

    protected Policy[] doGetPoliciesAsArray() throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)GET_POLICY_PERMISSION);
        return this.policyManager.getPoliciesAsArray();
    }

    protected void doAddPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)ADD_POLICY_PERMISSION);
        this.policyManager.addPolicy(policy);
    }

    protected void doRemovePolicy(Policy policy, boolean localRemove) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_POLICY_PERMISSION);
        this.policyManager.removePolicy(policy);
    }

    protected void doRemovePolicy(String contextId, boolean localRemove) throws ServiceException, SecurityException {
        LoginService.checkPermission((Permission)REMOVE_POLICY_PERMISSION);
        this.policyManager.removePolicy(contextId);
    }

    protected void doSave() throws ServiceException, SecurityException {
    }

    protected void refreshRepositryService() throws ServiceException {
    }

    public Object readPoliciesInRepository() throws ServiceException {
        return null;
    }

    public void writePoliciesToRepository(Object policies) throws ServiceException {
    }
}

