/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.aznrep;

import java.security.Permission;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.PolicyFactory;
import jeus.security.base.Role;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.RoleImpl;
import jeus.security.util.Constants;
import jeus.security.util.PermissionMaker;
import jeus.security.util.XMLConverter;
import jeus.xml.binding.jeusDD.EmptyType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.PoliciesType;
import jeus.xml.binding.jeusDD.PolicyType;
import jeus.xml.binding.jeusDD.ResourcePermissionType;
import jeus.xml.binding.jeusDD.ResourcePermissionsType;
import jeus.xml.binding.jeusDD.RolePermissionType;
import jeus.xml.binding.jeusDD.RolePermissionsType;

public class XMLCustomPoliciesConverter
extends XMLConverter {
    private ObjectFactory of = new ObjectFactory();
    private String policyClassName;
    private String userPrincipalClassName;
    private String rolePrincipalClassName;

    public XMLCustomPoliciesConverter() throws Exception {
        super("jeus.xml.binding.jeusDD");
    }

    public XMLCustomPoliciesConverter(String policyClassName, String userPrincipalClassName, String rolePrincipalClassName) throws Exception {
        super("jeus.xml.binding.jeusDD");
        this.policyClassName = policyClassName;
        this.userPrincipalClassName = userPrincipalClassName;
        this.rolePrincipalClassName = rolePrincipalClassName;
    }

    protected Object fromXMLTree(Object contentTree) throws Exception {
        Vector<Policy> v = new Vector<Policy>();
        PoliciesType pt = (PoliciesType)contentTree;
        PolicyType policy = pt.getPolicy();
        Policy dpc = PolicyFactory.getPolicyFactory(this.policyClassName);
        RolePermissionsType rpt = policy.getRolePermissions();
        if (rpt != null) {
            dpc.getRolePolicy().add(this.getRolePermissionsPC(rpt));
        }
        for (ResourcePermissionsType resPerms : policy.getResourcePermissions()) {
            String id = resPerms.getContextId() == null ? "default" : resPerms.getContextId();
            dpc.getResourcePolicy(id, true).add(this.getResourcePermissionsPC(resPerms));
        }
        dpc.setUserPrincipalClassName(this.userPrincipalClassName);
        dpc.setRolePrincipalClassName(this.rolePrincipalClassName);
        v.add(dpc);
        return v.toArray(new Policy[v.size()]);
    }

    private PermissionMap getRolePermissionsPC(RolePermissionsType rpst) throws Exception {
        Iterator rps = rpst.getRolePermission().iterator();
        PermissionMap pc = new PermissionMap();
        while (rps.hasNext()) {
            RolePermissionType rpt = (RolePermissionType)rps.next();
            String className = rpt.getClassname() == null ? Constants.DEFAULT_PR_PERMISSION_CLASSNAME : rpt.getClassname();
            String role = rpt.getRole();
            String actions = rpt.getActions();
            Permission p = PermissionMaker.makePermission((String)className, (String)role, (String)actions);
            EmptyType ex = rpt.getExcluded();
            EmptyType un = rpt.getUnchecked();
            boolean excluded = false;
            boolean unchecked = false;
            if (ex != null) {
                excluded = true;
            }
            if (un != null) {
                unchecked = true;
            }
            int i = 0;
            List principals = rpt.getPrincipal();
            Object[] princes = new Object[principals.size()];
            for (String pp : principals) {
                princes[i++] = new PrincipalImpl(pp);
            }
            pc.addPermission(p, princes, excluded, unchecked);
        }
        return pc;
    }

    private PermissionMap getResourcePermissionsPC(ResourcePermissionsType rpst) throws Exception {
        Iterator rps = rpst.getResourcePermission().iterator();
        PermissionMap pc = new PermissionMap(true);
        while (rps.hasNext()) {
            ResourcePermissionType rpt = (ResourcePermissionType)rps.next();
            String className = rpt.getClassname() == null ? Constants.DEFAULT_RR_PERMISSION_CLASSNAME : rpt.getClassname();
            String resource = rpt.getResource();
            String actions = rpt.getActions();
            Permission p = PermissionMaker.makePermission((String)className, (String)resource, (String)actions);
            EmptyType ex = rpt.getExcluded();
            EmptyType un = rpt.getUnchecked();
            boolean excluded = false;
            boolean unchecked = false;
            if (ex != null) {
                excluded = true;
            }
            if (un != null) {
                unchecked = true;
            }
            int i = 0;
            List roles = rpt.getRole();
            Object[] rls = new Object[roles.size()];
            for (String pp : roles) {
                rls[i++] = new RoleImpl(pp);
            }
            pc.addPermission(p, rls, excluded, unchecked);
        }
        return pc;
    }

    protected Object toXMLTree(Object object, Object tree) throws Exception {
        Policy[] dpcs = (Policy[])object;
        if (tree == null) {
            tree = this.of.createPoliciesType();
        }
        PoliciesType pt = (PoliciesType)tree;
        for (int i = 0; i < dpcs.length; ++i) {
            this.addToTree(dpcs[i], pt);
        }
        ObjectFactory fac = new ObjectFactory();
        return fac.createPolicies(pt);
    }

    private void addToTree(Policy ap, PoliciesType pt) throws Exception {
        PolicyType pType = this.of.createPolicyType();
        RolePermissionsType rpt = this.of.createRolePermissionsType();
        PermissionMap prPC = ap.getRolePolicy();
        this.addRolePC(prPC, rpt);
        pType.setRolePermissions(rpt);
        for (String contextId : ap.getResourcePolicyIds()) {
            ResourcePermissionsType resPerms = this.of.createResourcePermissionsType();
            PermissionMap pm = ap.getResourcePolicy(contextId);
            if (pm == null) continue;
            resPerms.setContextId(contextId);
            this.addResourcePC(pm, resPerms);
            pType.getResourcePermissions().add(resPerms);
        }
        pt.setPolicy(pType);
    }

    private void addRolePC(PermissionMap pc, RolePermissionsType pt) throws Exception {
        Iterator all = pc.getAllPermissions().iterator();
        while (all.hasNext()) {
            RolePermissionType rpt = this.of.createRolePermissionType();
            Permission p = (Permission)all.next();
            rpt.setRole(p.getName());
            if (p.getActions() != null) {
                rpt.setActions(p.getActions());
            }
            rpt.setClassname(p.getClass().getName());
            for (Principal prince : pc.getCheckedPermissionOwners(p)) {
                rpt.getPrincipal().add(prince.getName());
            }
            if (pc.getExcludedPermissions().contains(p)) {
                rpt.setExcluded(this.of.createEmptyType());
            }
            if (pc.getUncheckedPermissions().contains(p)) {
                rpt.setUnchecked(this.of.createEmptyType());
            }
            pt.getRolePermission().add(rpt);
        }
    }

    private void addResourcePC(PermissionMap pc, ResourcePermissionsType rrst) throws Exception {
        Iterator all = pc.getAllPermissions().iterator();
        while (all.hasNext()) {
            ResourcePermissionType rrt = this.of.createResourcePermissionType();
            Permission p = (Permission)all.next();
            rrt.setResource(p.getName());
            if (p.getActions() != null) {
                rrt.setActions(p.getActions());
            }
            rrt.setClassname(p.getClass().getName());
            for (Role role : pc.getCheckedPermissionOwners(p)) {
                rrt.getRole().add(role.getName());
            }
            if (pc.getExcludedPermissions().contains(p)) {
                rrt.setExcluded(this.of.createEmptyType());
            }
            if (pc.getUncheckedPermissions().contains(p)) {
                rrt.setUnchecked(this.of.createEmptyType());
            }
            rrst.getResourcePermission().add(rrt);
        }
    }
}

